/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lexCheck.CkLib;

import gov.nih.nlm.nls.lexCheck.Lib.CheckFormat;
import java.util.HashSet;

public class CheckObject {
    private String startStr_ = null;
    private String delim_ = "=";
    private int startErrMsg_ = -1;
    private int fillerErrMsg_ = -1;
    private int nextState_ = 0;
    private HashSet nextStartStrs_ = null;
    private HashSet nextLine_ = null;
    private CheckFormat fillerFormat_ = null;
    private boolean isTab_ = false;

    public CheckObject(String startStr, int startErrMsg, int fillerErrMsg, int nextState, HashSet nextStartStrs, CheckFormat fillerFormat) {
        this.startStr_ = startStr;
        this.delim_ = "=";
        this.startErrMsg_ = startErrMsg;
        this.fillerErrMsg_ = fillerErrMsg;
        this.nextState_ = nextState;
        this.nextStartStrs_ = nextStartStrs;
        this.nextLine_ = null;
        this.fillerFormat_ = fillerFormat;
        if (startStr != null) {
            this.isTab_ = startStr.startsWith("\t");
        }
    }

    public CheckObject(String startStr, int startErrMsg, int fillerErrMsg, int nextState, HashSet nextStartStrs, HashSet nextLine, CheckFormat fillerFormat) {
        this(startStr, startErrMsg, fillerErrMsg, nextState, nextStartStrs, fillerFormat);
        this.nextLine_ = nextLine;
    }

    public CheckObject(String startStr, int startErrMsg, int fillerErrMsg, int nextState, HashSet nextStartStrs, CheckFormat fillerFormat, String delim) {
        this(startStr, startErrMsg, fillerErrMsg, nextState, nextStartStrs, fillerFormat);
        this.delim_ = delim;
    }

    public CheckObject(String startStr, int startErrMsg, int fillerErrMsg, int nextState, HashSet nextStartStrs, HashSet nextLine, CheckFormat fillerFormat, String delim) {
        this(startStr, startErrMsg, fillerErrMsg, nextState, nextStartStrs, nextLine, fillerFormat);
        this.delim_ = delim;
    }

    public String GetStartStr() {
        return this.startStr_;
    }

    public String GetDelim() {
        return this.delim_;
    }

    public int GetStartErrMsg() {
        return this.startErrMsg_;
    }

    public int GetFillerErrMsg() {
        return this.fillerErrMsg_;
    }

    public int GetNextState() {
        return this.nextState_;
    }

    public HashSet GetNextStartStrs() {
        return this.nextStartStrs_;
    }

    public HashSet GetNextLine() {
        return this.nextLine_;
    }

    public boolean IsNextStartStr(String line) {
        boolean flag = false;
        block0: for (String itNext : this.nextStartStrs_) {
            if (!line.startsWith(itNext)) continue;
            flag = true;
            if (this.nextLine_ == null) break;
            for (String it2Next : this.nextLine_) {
                if (!line.startsWith(it2Next) || line.equals(it2Next)) continue;
                flag = false;
                break block0;
            }
        }
        return flag;
    }

    public CheckFormat GetFillerFormat() {
        return this.fillerFormat_;
    }

    public boolean IsTab() {
        return this.isTab_;
    }
}

