/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lexCheck.Tools;

import gov.nih.nlm.nls.lexCheck.Api.ToJavaObjApi;
import gov.nih.nlm.nls.lexCheck.Lib.InflVar;
import gov.nih.nlm.nls.lexCheck.Lib.LexRecord;
import gov.nih.nlm.nls.lvg.Lib.Category;
import gov.nih.nlm.nls.lvg.Lib.Inflection;
import java.util.Vector;

public class ToJavaObjectFromXmlFile {
    public static void main(String[] argv) {
        if (argv.length == 0 || argv.length > 2) {
            System.err.println("** Usage: java ToJavaObjectFromXmlFile <inFile(Xml)> <-i>");
            System.err.println("   [-i]: generate inflection vars");
            System.exit(1);
        }
        boolean inflVarFlag = false;
        for (int i = 0; i < argv.length; ++i) {
            if (!argv[i].equals("-i")) continue;
            inflVarFlag = true;
            break;
        }
        try {
            Vector<LexRecord> lexRecords = ToJavaObjApi.ToJavaObjsFromXmlFile(argv[0]);
            if (lexRecords.size() <= 0) {
                System.exit(1);
            } else {
                for (int i = 0; i < lexRecords.size(); ++i) {
                    LexRecord lexRecord = lexRecords.elementAt(i);
                    System.out.print(lexRecord.GetText());
                    if (!inflVarFlag) continue;
                    System.out.println("---------- Inflection Vars ----------");
                    Vector<InflVar> inflVars = lexRecord.GetInflVarsAndAgreements().GetInflValues();
                    for (int j = 0; j < inflVars.size(); ++j) {
                        InflVar inflVar = inflVars.elementAt(j);
                        System.out.println(inflVar.GetVar() + "|" + Category.ToValue(inflVar.GetCat()) + "|" + Inflection.ToValue(inflVar.GetInflection()) + "|" + inflVar.GetEui() + "|" + inflVar.GetUnInfl() + "|" + inflVar.GetCit());
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

