/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Db.DbFruitful;
import gov.nih.nlm.nls.lvg.Db.FruitfulRecord;
import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.GlobalBehavior;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;

public class ToFruitfulVariantsDb
extends Transformation
implements Cloneable {
    private static final String INFO = "Fruitful Variants Db";

    public static Vector<LexItem> Mutate(LexItem in, Connection conn, boolean detailsFlag, boolean mutateFlag) {
        Vector<FruitfulRecord> records = ToFruitfulVariantsDb.GetFruitfulVariants(in.GetSourceTerm(), conn);
        Vector<LexItem> out = new Vector<LexItem>();
        for (int i = 0; i < records.size(); ++i) {
            FruitfulRecord record = records.elementAt(i);
            String term = record.GetVariantTerm();
            String details = null;
            String mutate = null;
            if (detailsFlag) {
                details = INFO;
            }
            if (mutateFlag) {
                String fs = GlobalBehavior.GetFieldSeparator();
                mutate = record.GetOriginalCategory() + fs + record.GetOriginalInflection() + fs + record.GetFlowHistory() + fs + record.GetDistance() + fs + record.GetTagInformation() + fs;
            }
            LexItem temp = ToFruitfulVariantsDb.UpdateLexItem(in, term, 46, record.GetCategory(), record.GetInflection(), details, mutate);
            out.addElement(temp);
        }
        return out;
    }

    public static void main(String[] args) {
        Configuration conf = new Configuration("data.config.lvg", true);
        String testStr = ToFruitfulVariantsDb.GetTestStr(args, "neurological");
        LexItem in = new LexItem(testStr);
        Vector<LexItem> outs = new Vector<LexItem>();
        try {
            Connection conn = DbBase.OpenConnection(conf);
            if (conn != null) {
                outs = ToFruitfulVariantsDb.Mutate(in, conn, true, true);
            }
            DbBase.CloseConnection(conn, conf);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        ToFruitfulVariantsDb.PrintResults(in, outs);
    }

    private static Vector<FruitfulRecord> GetFruitfulVariants(String inStr, Connection conn) {
        String strLc = inStr.toLowerCase();
        Vector<FruitfulRecord> out = new Vector<FruitfulRecord>();
        try {
            out = DbFruitful.GetFruitfulVariants(strLc, conn);
        }
        catch (SQLException e) {
            // empty catch block
        }
        return out;
    }
}

