/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Trie.RTrieTree;
import java.util.Vector;

public class ToRemoveS
extends Transformation
implements Cloneable {
    private static final String INFO = "Remove (s), (es), (ies)";
    private static final String S = "(s)";
    private static final String ES = "(es)";
    private static final String IES = "(ies)";

    public static Vector<LexItem> Mutate(LexItem in, RTrieTree trie, boolean detailsFlag, boolean mutateFlag) {
        String term = ToRemoveS.RemoveSFromTerm(in.GetSourceTerm(), trie);
        String details = null;
        String mutate = null;
        if (detailsFlag) {
            details = INFO;
        }
        if (mutateFlag) {
            mutate = Transformation.NO_MUTATE_INFO;
        }
        Vector<LexItem> out = new Vector<LexItem>();
        LexItem temp = ToRemoveS.UpdateLexItem(in, term, 58, -1L, -1L, details, mutate);
        out.addElement(temp);
        return out;
    }

    public static RTrieTree GetRTrieTreeFromFile(Configuration config) {
        String fName = config.GetConfiguration("LVG_DIR") + config.GetConfiguration("LVG_REMOVE_S_FILE");
        RTrieTree tree = new RTrieTree(fName);
        return tree;
    }

    public static void main(String[] args) {
        Configuration conf = new Configuration("data.config.lvg", true);
        String testStr = ToRemoveS.GetTestStr(args, "Ap(s)pCHClpp(s)A");
        String lvgDir = conf.GetConfiguration("LVG_DIR");
        String fName = lvgDir + "/data/rules/removeS.data";
        try {
            RTrieTree tree = new RTrieTree(fName);
            LexItem in = new LexItem(testStr);
            Vector<LexItem> outs = ToRemoveS.Mutate(in, tree, true, true);
            ToRemoveS.PrintResults(in, outs);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    private static String RemoveSFromTerm(String inStr, RTrieTree tree) {
        String outStr = new String();
        outStr = ToRemoveS.RemovePattern(inStr, ES);
        outStr = ToRemoveS.RemovePattern(outStr, IES);
        int patternSize = S.length();
        String lowerStr = outStr.toLowerCase();
        int index = lowerStr.indexOf(S);
        int outSize = outStr.length();
        while (index >= 0) {
            String str1 = outStr.substring(0, index);
            String str2 = outStr.substring(index + patternSize, outSize);
            if (!tree.FindPattern(str1)) {
                char nextChar;
                outStr = str1 + str2;
                if (str2.length() > 0 && Character.isLetter(nextChar = str2.charAt(0))) {
                    outStr = str1 + " " + str2;
                }
                lowerStr = outStr.toLowerCase();
                index = lowerStr.indexOf(S);
            } else {
                lowerStr = outStr.toLowerCase();
                index = lowerStr.indexOf(S, index + 1);
            }
            outSize = outStr.length();
        }
        return outStr;
    }

    private static String RemovePattern(String term, String pattern) {
        String outStr = term;
        String lowerStr = outStr.toLowerCase();
        int patternSize = pattern.length();
        int index = lowerStr.indexOf(pattern);
        int outSize = outStr.length();
        while (index >= 0) {
            String str1 = ToRemoveS.TrimEnd(outStr.substring(0, index));
            String str2 = outStr.substring(index + patternSize, outSize);
            outStr = str1 + str2;
            lowerStr = outStr.toLowerCase();
            index = lowerStr.indexOf(pattern);
            outSize = outStr.length();
        }
        return outStr;
    }

    private static String TrimEnd(String term) {
        String outStr = term;
        while (outStr.endsWith(" ")) {
            outStr = outStr.substring(0, outStr.length() - 1);
        }
        return outStr;
    }
}

