/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Util.StrTokenObject;
import gov.nih.nlm.nls.lvg.Util.Strip;
import gov.nih.nlm.nls.lvg.Util.StripToken;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Vector;

public class ToStripStopWords
extends Transformation
implements Cloneable {
    private static final String INFO = "Strip Stop Words";

    public static Vector<LexItem> Mutate(LexItem in, Vector<String> stopWords, boolean detailsFlag, boolean mutateFlag) {
        String term = ToStripStopWords.StripStopWords(in.GetSourceTerm(), stopWords);
        Vector<String> multipleStopWords = ToStripStopWords.GetMultipleStopWords(stopWords);
        term = Strip.StripStrings(term, multipleStopWords, false);
        String details = null;
        String mutate = null;
        if (detailsFlag) {
            details = INFO;
        }
        if (mutateFlag) {
            mutate = Transformation.NO_MUTATE_INFO;
        }
        Vector<LexItem> out = new Vector<LexItem>();
        LexItem temp = ToStripStopWords.UpdateLexItem(in, term, 2, -1L, -1L, details, mutate);
        out.addElement(temp);
        return out;
    }

    public static Vector<String> GetStopWordsFromFile(Configuration config) {
        String fName = config.GetConfiguration("LVG_DIR") + config.GetConfiguration("LVG_STOP_WORD_FILE");
        String line = null;
        Vector<String> stopWords = new Vector<String>();
        try {
            BufferedReader in = new BufferedReader(new FileReader(fName));
            while ((line = in.readLine()) != null) {
                if (line.length() <= 0 || line.charAt(0) == '#') continue;
                stopWords.addElement(line);
            }
            in.close();
        }
        catch (Exception e) {
            System.err.println("Exception: " + e.toString());
            System.err.println("** Error: problem of opening/reading stop words file: '" + fName + "'.");
        }
        return stopWords;
    }

    public static void main(String[] args) {
        Configuration conf = new Configuration("data.config.lvg", true);
        String testStr = ToStripStopWords.GetTestStr(args, "On the Top");
        Vector<String> stopWords = ToStripStopWords.GetStopWordsFromFile(conf);
        LexItem in = new LexItem(testStr);
        Vector<LexItem> outs = ToStripStopWords.Mutate(in, stopWords, true, true);
        ToStripStopWords.PrintResults(in, outs);
    }

    private static String StripStopWords(String inStr, Vector<String> stopWords) {
        Vector<StrTokenObject> list = StripToken.Tokenize(inStr);
        Vector<StrTokenObject> newList = new Vector<StrTokenObject>(list);
        for (int i = 0; i < list.size(); ++i) {
            StrTokenObject cur = list.elementAt(i);
            if (cur.GetTokenType() != 1 || !ToStripStopWords.IsContain(stopWords, cur.GetTokenStr())) continue;
            StrTokenObject temp = new StrTokenObject(" ", 3);
            newList.setElementAt(temp, i);
        }
        Vector<StrTokenObject> cleanList = StripToken.CleanUpToken(newList);
        return StripToken.ComposeString(cleanList).trim();
    }

    private static Vector<String> GetMultipleStopWords(Vector<String> stopWords) {
        Vector<String> out = new Vector<String>();
        if (stopWords == null) {
            return stopWords;
        }
        for (int i = 0; i < stopWords.size(); ++i) {
            String cur = stopWords.elementAt(i);
            if (cur.indexOf(" ") == -1) continue;
            out.addElement(cur);
        }
        return out;
    }

    private static boolean IsContain(Vector<String> list, String inStr) {
        if (list == null) {
            return false;
        }
        boolean isContain = false;
        for (int i = 0; i < list.size(); ++i) {
            if (!inStr.equalsIgnoreCase(list.elementAt(i))) continue;
            isContain = true;
            break;
        }
        return isContain;
    }
}

