/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Trie;

import gov.nih.nlm.nls.lvg.Lib.CatInfl;
import gov.nih.nlm.nls.lvg.Lib.Category;
import gov.nih.nlm.nls.lvg.Lib.Inflection;
import gov.nih.nlm.nls.lvg.Trie.InflectionRule;
import gov.nih.nlm.nls.lvg.Trie.PersistentExceptionNode;
import gov.nih.nlm.nls.lvg.Trie.PersistentRuleNode;
import gov.nih.nlm.nls.lvg.Trie.PersistentTrieNode;
import gov.nih.nlm.nls.lvg.Trie.RuleResult;
import gov.nih.nlm.nls.lvg.Trie.RuleResultComparator;
import gov.nih.nlm.nls.lvg.Trie.WildCard;
import gov.nih.nlm.nls.lvg.Util.Bit;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.Vector;

public final class PersistentTrie {
    public static final long LEGAL_CATEGORY = 1155L;
    public static final long LEGAL_INFLECTION = 2099071L;
    public static final long LEGAL_BASE = 1793L;
    private Vector<PersistentTrieNode> foundNodeList_ = null;
    private PersistentTrieNode root_ = null;
    private PersistentTrieNode foundNode_ = null;
    private RandomAccessFile trieRaf_ = null;
    private RandomAccessFile ruleRaf_ = null;
    private RandomAccessFile exceptionRaf_ = null;
    private int matchedNodeNum_ = 0;
    private int minTermLength_ = 2;
    private boolean isInflection_ = true;

    public PersistentTrie(boolean isInflection, int minTermLength, String dir) {
        this.isInflection_ = isInflection;
        this.minTermLength_ = minTermLength;
        String triePath = dir + "/data/rules/trieI.data";
        String rulePath = dir + "/data/rules/ruleI.data";
        String exceptionPath = dir + "/data/rules/exceptionI.data";
        if (!isInflection) {
            triePath = dir + "/data/rules/trieD.data";
            rulePath = dir + "/data/rules/ruleD.data";
            exceptionPath = dir + "/data/rules/exceptionD.data";
        }
        try {
            RandomAccessFile trieRaf = new RandomAccessFile(triePath, "r");
            RandomAccessFile ruleRaf = new RandomAccessFile(rulePath, "r");
            RandomAccessFile exceptionRaf = new RandomAccessFile(exceptionPath, "r");
            this.trieRaf_ = trieRaf;
            this.ruleRaf_ = ruleRaf;
            this.exceptionRaf_ = exceptionRaf;
            this.root_ = (PersistentTrieNode)PersistentTrieNode.GetNode(this.trieRaf_, 0L);
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public PersistentTrie(RandomAccessFile trieRaf, RandomAccessFile ruleRaf, RandomAccessFile exceptionRaf, int minTermLength, boolean isInflection) {
        this.isInflection_ = isInflection;
        this.minTermLength_ = minTermLength;
        this.trieRaf_ = trieRaf;
        this.ruleRaf_ = ruleRaf;
        this.exceptionRaf_ = exceptionRaf;
        try {
            this.root_ = (PersistentTrieNode)PersistentTrieNode.GetNode(this.trieRaf_, 0L);
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public void Close() {
        try {
            this.trieRaf_.close();
            this.ruleRaf_.close();
            this.exceptionRaf_.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Vector<RuleResult> GetUninflectedTermsByRules(String term, long inCat, long inInfl, boolean showAll) {
        Vector<RuleResult> resultList = this.Mutate(term, showAll, inCat, inInfl, 1155L, 1793L);
        RuleResultComparator rrc = new RuleResultComparator();
        Collections.sort(resultList, rrc);
        return resultList;
    }

    public CatInfl GetCatInflByRules(String term, long inCat, long inInfl) {
        Vector resultList = new Vector();
        long cat = 0L;
        long infl = 0L;
        try {
            Vector<PersistentTrieNode> matchNodeList = this.FindRule(term);
            this.matchedNodeNum_ = matchNodeList.size();
            boolean curLevel = false;
            for (int i = 0; i < matchNodeList.size(); ++i) {
                PersistentTrieNode node = matchNodeList.elementAt(i);
                long ruleAddess = node.GetRuleAddress();
                if (node == null || ruleAddess == -1L) {
                    System.out.println("** Error: null in TrieNode or it's rules");
                    break;
                }
                long nextAddress = ruleAddess;
                if (nextAddress == -1L) continue;
                nextAddress += 12L;
                while (nextAddress != -1L) {
                    PersistentRuleNode ruleNode = (PersistentRuleNode)PersistentRuleNode.GetNode(this.ruleRaf_, nextAddress);
                    InflectionRule rule = new InflectionRule(ruleNode.GetRuleString());
                    if (!this.IsException(term, ruleNode.GetExceptionAddress())) {
                        long curCat = rule.GetInCategory();
                        long curInfl = rule.GetInInflection();
                        if (Bit.Contain(inCat, curCat) && Bit.Contain(inInfl, curInfl)) {
                            cat |= curCat;
                            infl |= curInfl;
                        }
                    }
                    nextAddress = ruleNode.GetNext();
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        CatInfl catInfl = new CatInfl(cat, infl);
        return catInfl;
    }

    public Vector<CatInfl> GetCatInflsByRules(String term, long inCat, long inInfl) {
        Vector resultList = new Vector();
        long cat = 0L;
        long infl = 0L;
        Vector<CatInfl> outs = new Vector<CatInfl>();
        try {
            Vector<PersistentTrieNode> matchNodeList = this.FindRule(term);
            this.matchedNodeNum_ = matchNodeList.size();
            boolean curLevel = false;
            for (int i = 0; i < matchNodeList.size(); ++i) {
                PersistentTrieNode node = matchNodeList.elementAt(i);
                long ruleAddess = node.GetRuleAddress();
                if (node == null || ruleAddess == -1L) {
                    System.out.println("** Error: null in TrieNode or it's rules");
                    break;
                }
                long nextAddress = ruleAddess;
                if (nextAddress == -1L) continue;
                nextAddress += 12L;
                while (nextAddress != -1L) {
                    PersistentRuleNode ruleNode = (PersistentRuleNode)PersistentRuleNode.GetNode(this.ruleRaf_, nextAddress);
                    InflectionRule rule = new InflectionRule(ruleNode.GetRuleString());
                    if (!this.IsException(term, ruleNode.GetExceptionAddress())) {
                        long curCat = rule.GetInCategory();
                        long curInfl = rule.GetInInflection();
                        CatInfl catInfl = new CatInfl(curCat, curInfl);
                        outs.addElement(catInfl);
                    }
                    nextAddress = ruleNode.GetNext();
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return outs;
    }

    public Vector<RuleResult> GetInflectedTermsByRules(String term, long inCat, long inInfl, boolean showAll) {
        Vector<RuleResult> uninflectedList = this.Mutate(term, showAll, inCat, inInfl, 1155L, 1793L);
        Vector<RuleResult> resultList = new Vector<RuleResult>();
        String lastTerm = null;
        long lastCat = -1L;
        for (int i = 0; i < uninflectedList.size(); ++i) {
            RuleResult temp = uninflectedList.elementAt(i);
            String tempTerm = temp.GetOutTerm();
            String ruleStr = temp.GetRuleString();
            long cat = Category.ToValue(temp.GetOutCategory());
            Vector<RuleResult> tempResult = new Vector();
            if (cat != lastCat || !tempTerm.equals(lastTerm)) {
                tempResult = this.Mutate(tempTerm, showAll, cat, 2099071L, 1155L, 2099071L);
            }
            lastTerm = tempTerm;
            lastCat = cat;
            Vector<RuleResult> newTempResult = this.RemoveIllegalTerms(tempTerm, tempResult);
            resultList = PersistentTrie.AddRusultsToInflectList(resultList, newTempResult);
        }
        RuleResultComparator rrc = new RuleResultComparator();
        Collections.sort(resultList, rrc);
        return resultList;
    }

    private Vector<RuleResult> RemoveIllegalTerms(String base, Vector<RuleResult> inflections) {
        Vector<RuleResult> out = new Vector<RuleResult>();
        for (int i = 0; i < inflections.size(); ++i) {
            RuleResult temp = inflections.elementAt(i);
            String tempTerm = temp.GetOutTerm();
            String ruleStr = temp.GetRuleString();
            long infl = Inflection.ToValue(temp.GetOutInflection());
            if (Inflection.Contains(1793L, infl) && !base.equals(tempTerm)) continue;
            out.addElement(temp);
        }
        return out;
    }

    public Vector<RuleResult> GetDerivationsByRules(String term, long inCat, long inInfl, boolean showAll) {
        Vector<RuleResult> resultList = this.Mutate(term, showAll, inCat, inInfl, 1155L, 1793L);
        return resultList;
    }

    public void PrintResults(Vector<RuleResult> resultList) {
        System.out.println("-- matchNodeList size: " + this.GetMatchedNodeNum());
        for (int i = 0; i < resultList.size(); ++i) {
            RuleResult result = resultList.elementAt(i);
            System.out.println(result.GetInTerm() + " --> " + result.GetOutTerm() + " ... Rule: " + result.GetRuleString());
        }
    }

    public int GetMatchedNodeNum() {
        return this.matchedNodeNum_;
    }

    public void SetMinTermLength(int minTermLength) {
        this.minTermLength_ = minTermLength;
    }

    public static void main(String[] args) {
        if (args.length != 3) {
            System.out.println("Usage: java PersistentTrie <term> <-i/d> <-s>");
            System.out.println(" term: input term for testing");
            System.out.println(" -i/d: Get inflection/Derivation");
            System.out.println("   -s: mutate with all branch rules applied");
        } else {
            String inStr = args[0];
            String triePath = "../data/rules/trieI.data";
            String rulePath = "../data/rules/ruleI.data";
            String exceptionPath = "../data/rules/exceptionI.data";
            boolean isInflection = true;
            if (args[1].equals("-d")) {
                triePath = "../data/rules/trieD.data";
                rulePath = "../data/rules/ruleD.data";
                exceptionPath = "../data/rules/exceptionD.data";
                isInflection = false;
            }
            boolean showAll = false;
            if (args[2].equals("-s")) {
                showAll = true;
            }
            try {
                RandomAccessFile trieRaf = new RandomAccessFile(triePath, "r");
                RandomAccessFile ruleRaf = new RandomAccessFile(rulePath, "r");
                RandomAccessFile exceptionRaf = new RandomAccessFile(exceptionPath, "r");
                PersistentTrie trie = new PersistentTrie(trieRaf, ruleRaf, exceptionRaf, 3, isInflection);
                if (isInflection) {
                    System.out.println("-------- Uninflected Terms ----------");
                    Vector<RuleResult> result = trie.GetUninflectedTermsByRules(inStr, 2047L, 0xFFFFFFL, true);
                    trie.PrintResults(result);
                    System.out.println("-------- Inflected Terms ------------");
                    result = trie.GetInflectedTermsByRules(inStr, 2047L, 0xFFFFFFL, true);
                    trie.PrintResults(result);
                    System.out.println("------ Category & Inflection -----");
                    CatInfl catInfl = trie.GetCatInflByRules(inStr, 2047L, 0xFFFFFFL);
                    System.out.println(catInfl.GetCategory() + ", " + catInfl.GetInflection());
                    System.out.println("------ Categories & Inflections -----");
                    Vector<CatInfl> result2 = trie.GetCatInflsByRules(inStr, 2047L, 0xFFFFFFL);
                    for (int i = 0; i < result2.size(); ++i) {
                        catInfl = result2.elementAt(i);
                        System.out.println(catInfl.GetCategory() + ", " + catInfl.GetInflection());
                    }
                } else {
                    System.out.println("---------- Derivations -------------");
                    Vector<RuleResult> result = trie.GetDerivationsByRules(inStr, 2047L, 0xFFFFFFL, true);
                    trie.PrintResults(result);
                }
                trieRaf.close();
                ruleRaf.close();
                exceptionRaf.close();
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
        }
    }

    private Vector<RuleResult> Mutate(String term, boolean showAll, long inCategory, long inInflection, long outCategory, long outInflection) {
        Vector<RuleResult> resultList = new Vector<RuleResult>();
        try {
            Vector<PersistentTrieNode> matchNodeList = this.FindRule(term);
            this.matchedNodeNum_ = matchNodeList.size();
            int curLevel = 0;
            for (int i = 0; i < this.matchedNodeNum_; ++i) {
                PersistentTrieNode node = matchNodeList.elementAt(i);
                long ruleAddess = node.GetRuleAddress();
                if (node == null || ruleAddess == -1L) {
                    System.out.println("** Error: null in TrieNode or it's rules");
                    break;
                }
                long nextAddress = ruleAddess;
                if (nextAddress == -1L) continue;
                nextAddress += 12L;
                while (nextAddress != -1L) {
                    RuleResult result;
                    PersistentRuleNode ruleNode = (PersistentRuleNode)PersistentRuleNode.GetNode(this.ruleRaf_, nextAddress);
                    InflectionRule rule = new InflectionRule(ruleNode.GetRuleString());
                    if (!this.IsException(term, ruleNode.GetExceptionAddress()) && (result = this.ApplyRules(term, rule, inCategory, inInflection, outCategory, outInflection)) != null) {
                        if (showAll) {
                            resultList.add(result);
                        } else if (node.GetLevel() > curLevel) {
                            curLevel = node.GetLevel();
                            resultList.removeAllElements();
                            resultList.add(result);
                        } else if (node.GetLevel() == curLevel) {
                            resultList.add(result);
                        }
                    }
                    nextAddress = ruleNode.GetNext();
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!this.isInflection_) {
            return resultList;
        }
        Vector<RuleResult> out = new Vector<RuleResult>();
        for (int i = 0; i < resultList.size(); ++i) {
            RuleResult temp = resultList.elementAt(i);
            String tempStr = temp.GetOutTerm();
            if (tempStr.length() <= this.minTermLength_ && !tempStr.equals(term)) continue;
            out.addElement(temp);
        }
        return out;
    }

    static Vector<RuleResult> AddRusultsToInflectList(Vector<RuleResult> oldList, Vector<RuleResult> newList) {
        Vector<RuleResult> out = new Vector<RuleResult>(oldList);
        for (int i = 0; i < newList.size(); ++i) {
            RuleResult temp = newList.elementAt(i);
            if (PersistentTrie.HasResultWithSameOut(out, temp)) continue;
            out.addElement(temp);
        }
        return out;
    }

    private static boolean HasResultWithSameOut(Vector<RuleResult> list, RuleResult result) {
        boolean hasSameOut = false;
        for (int i = 0; i < list.size(); ++i) {
            RuleResult temp = list.elementAt(i);
            if (!temp.GetOutTerm().equals(result.GetOutTerm()) || !temp.GetOutCategoryAndInflection().equals(result.GetOutCategoryAndInflection())) continue;
            hasSameOut = true;
            break;
        }
        return hasSameOut;
    }

    private Vector<PersistentTrieNode> FindRule(String inStr) throws IOException {
        String curStr = inStr.trim() + '$';
        char[] inCharArray = curStr.toCharArray();
        this.foundNodeList_ = new Vector();
        this.foundNodeList_.addElement(this.root_);
        this.FindNode(this.root_, inCharArray);
        return this.foundNodeList_;
    }

    private boolean IsException(String inStr, long exceptionAddress) throws IOException {
        boolean isException = false;
        long nextAddress = exceptionAddress;
        if (nextAddress != -1L) {
            nextAddress += 12L;
            while (nextAddress != -1L) {
                PersistentExceptionNode exceptionNode = (PersistentExceptionNode)PersistentExceptionNode.GetNode(this.exceptionRaf_, nextAddress);
                if (inStr.equals(exceptionNode.GetKey())) {
                    isException = true;
                    break;
                }
                nextAddress = exceptionNode.GetNext();
            }
        }
        return isException;
    }

    private RuleResult ApplyRules(String inStr, InflectionRule rule, long inCategory, long inInflection, long outCategory, long outInflection) {
        String tempStr = inStr + '$';
        String inSuffix = rule.GetInSuffix();
        String outSuffix = rule.GetOutSuffix();
        int tempSize = tempStr.length();
        int inSize = inSuffix.length();
        long inCat = Category.ToValue(rule.GetInCategoryStr());
        long outCat = Category.ToValue(rule.GetOutCategoryStr());
        long inInf = Inflection.ToValue(rule.GetInInflectionStr());
        long outInf = Inflection.ToValue(rule.GetOutInflectionStr());
        String unchangeStr = tempStr.substring(0, tempSize - inSize);
        String changeStr = WildCard.GetSuffix(inSuffix, outSuffix, tempStr);
        String outStr = unchangeStr + changeStr;
        outStr = outStr.substring(0, outStr.length() - 1);
        RuleResult out = null;
        if (Category.Contains(inCategory, inCat) && Category.Contains(outCategory, outCat) && Inflection.Contains(inInflection, inInf) && Inflection.Contains(outInflection, outInf)) {
            out = new RuleResult(inStr, outStr, rule.GetRuleStr());
        }
        return out;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean FindNode(PersistentTrieNode node, char[] charArray) throws IOException {
        char curKey = node.GetKey();
        int curLevel = node.GetLevel();
        int arraySize = Array.getLength(charArray);
        int index = arraySize - 1 - curLevel;
        if (!WildCard.IsMatchKey(curKey, index, charArray)) return false;
        long ruleAddress = node.GetRuleAddress();
        if (ruleAddress != -1L) {
            this.foundNode_ = node;
            this.AddNodeToFoundList();
        }
        if (index == 0) {
            return true;
        }
        boolean oneChildMatch = false;
        if (node.GetChild() == -1L) return true;
        long nextAddress = node.GetChild();
        while (nextAddress != -1L) {
            PersistentTrieNode nextNode = (PersistentTrieNode)PersistentTrieNode.GetNode(this.trieRaf_, nextAddress);
            if (this.FindNode(nextNode, charArray)) {
                oneChildMatch = true;
            }
            nextAddress = nextNode.GetNext();
        }
        if (!oneChildMatch) return true;
        this.AddNodeToFoundList();
        return true;
    }

    private void AddNodeToFoundList() {
        boolean duplicateNode = false;
        for (int i = 0; i < this.foundNodeList_.size(); ++i) {
            if (this.foundNode_ != this.foundNodeList_.elementAt(i)) continue;
            duplicateNode = true;
            break;
        }
        if (!duplicateNode) {
            this.foundNodeList_.addElement(this.foundNode_);
        }
    }
}

