/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.ant.tasks.support;

import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.tools.ant.util.FileNameMapper;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionMapper
implements FileNameMapper,
Comparator<String> {
    private List<String> versions;
    private String to;

    @Override
    public String[] mapFileName(String sourceFileName) {
        String originalFileName = new File(sourceFileName).getName();
        for (String version : this.versions) {
            int index = originalFileName.indexOf(version);
            if (index < 0) continue;
            String baseFilename = originalFileName.substring(0, index - 1);
            String extension = originalFileName.substring(index + version.length());
            String path = sourceFileName.substring(0, sourceFileName.length() - originalFileName.length());
            if ("flatten".equals(this.to)) {
                path = "";
            }
            return new String[]{path + baseFilename + extension};
        }
        return new String[]{sourceFileName};
    }

    @Override
    public void setFrom(String from) {
        String[] split = StringUtils.split(from, File.pathSeparator);
        Arrays.sort(split, this);
        this.versions = Arrays.asList(split);
    }

    @Override
    public void setTo(String to) {
        this.to = to;
    }

    @Override
    public int compare(String s1, String s2) {
        int lengthDiff = s2.length() - s1.length();
        return lengthDiff != 0 ? lengthDiff : s1.compareTo(s2);
    }
}

