/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.aggregation;

import java.util.ArrayList;
import java.util.List;
import simplenlg.aggregation.PhraseSet;
import simplenlg.features.DiscourseFunction;
import simplenlg.framework.NLGElement;
import simplenlg.phrasespec.SPhraseSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PhraseChecker {
    public static boolean sameSentences(NLGElement ... sentences) {
        boolean equal = false;
        if (sentences.length >= 2) {
            for (int i = 1; i < sentences.length; ++i) {
                equal = sentences[i - 1].equals(sentences[i]);
            }
        }
        return equal;
    }

    public static boolean expletiveSubjects(NLGElement ... sentences) {
        boolean expl = true;
        for (int i = 1; i < sentences.length && expl; ++i) {
            expl = sentences[i] instanceof SPhraseSpec ? ((SPhraseSpec)sentences[i]).getFeatureAsBoolean("expletive_subject") : false;
        }
        return expl;
    }

    public static boolean sameFrontMods(NLGElement ... sentences) {
        boolean equal = true;
        if (sentences.length >= 2) {
            for (int i = 1; i < sentences.length && equal; ++i) {
                equal = !sentences[i - 1].hasFeature("cue_phrase") && !sentences[i].hasFeature("cue_phrase") ? sentences[i - 1].getFeatureAsElementList("front_modifiers").equals(sentences[i].getFeatureAsElementList("front_modifiers")) : (sentences[i - 1].hasFeature("cue_phrase") && sentences[i].hasFeature("cue_phrase") ? sentences[i - 1].getFeatureAsElementList("front_modifiers").equals(sentences[i].getFeatureAsElementList("front_modifiers")) && sentences[i].getFeatureAsElementList("cue_phrase").equals(sentences[i - 1].getFeatureAsElementList("cue_phrase")) : false);
            }
        }
        return equal;
    }

    public static boolean samePostMods(NLGElement ... sentences) {
        boolean equal = true;
        if (sentences.length >= 2) {
            for (int i = 1; i < sentences.length && equal; ++i) {
                equal = sentences[i - 1].getFeatureAsElementList("postmodifiers").equals(sentences[i].getFeatureAsElementList("postmodifiers"));
            }
        }
        return equal;
    }

    public static boolean sameSubjects(NLGElement ... sentences) {
        boolean equal = sentences.length >= 2;
        for (int i = 1; i < sentences.length && equal; ++i) {
            equal = sentences[i - 1].getFeatureAsElementList("subjects").equals(sentences[i].getFeatureAsElementList("subjects"));
        }
        return equal;
    }

    public static boolean allPassive(NLGElement ... sentences) {
        boolean passive = true;
        for (int i = 0; i < sentences.length && passive; ++i) {
            passive = sentences[i].getFeatureAsBoolean("passive");
        }
        return passive;
    }

    public static boolean allActive(NLGElement ... sentences) {
        boolean active = true;
        for (int i = 0; i < sentences.length && active; ++i) {
            active = sentences[i].getFeatureAsBoolean("passive") == false;
        }
        return active;
    }

    public static boolean sameSurfaceSubjects(NLGElement ... sentences) {
        return PhraseChecker.allActive(sentences) && PhraseChecker.sameSubjects(sentences) || PhraseChecker.allPassive(sentences);
    }

    public static boolean sameVPHead(NLGElement ... sentences) {
        boolean equal = sentences.length >= 2;
        for (int i = 1; i < sentences.length && equal; ++i) {
            NLGElement vp1 = sentences[i - 1].getFeatureAsElement("verb_phrase");
            NLGElement vp2 = sentences[i].getFeatureAsElement("verb_phrase");
            if (vp1 != null && vp2 != null) {
                NLGElement h1 = vp1.getFeatureAsElement("head");
                NLGElement h2 = vp2.getFeatureAsElement("head");
                equal = h1 != null && h2 != null ? h1.equals(h2) : false;
                continue;
            }
            equal = false;
        }
        return equal;
    }

    public static boolean haveSameVoice(NLGElement ... sentences) {
        boolean samePassive = true;
        boolean prevIsPassive = false;
        if (sentences.length > 1) {
            prevIsPassive = sentences[0].getFeatureAsBoolean("passive");
            for (int i = 1; i < sentences.length && samePassive; ++i) {
                samePassive = sentences[i].getFeatureAsBoolean("passive") == prevIsPassive;
            }
        }
        return samePassive;
    }

    public static boolean sameVP(NLGElement ... sentences) {
        boolean equal = sentences.length >= 2;
        for (int i = 1; i < sentences.length && equal; ++i) {
            equal = sentences[i - 1].getFeatureAsElement("verb_phrase").equals(sentences[i].getFeatureAsElement("verb_phrase"));
        }
        return equal;
    }

    public static boolean sameVPArgs(NLGElement ... sentences) {
        boolean equal = sentences.length >= 2;
        for (int i = 1; i < sentences.length && equal; ++i) {
            NLGElement vp1 = sentences[i - 1].getFeatureAsElement("verb_phrase");
            NLGElement vp2 = sentences[i].getFeatureAsElement("verb_phrase");
            equal = vp1.getFeatureAsElementList("complements").equals(vp2.getFeatureAsElementList("complements"));
        }
        return equal;
    }

    public static boolean sameVPModifiers(NLGElement ... sentences) {
        boolean equal = sentences.length >= 2;
        for (int i = 1; i < sentences.length && equal; ++i) {
            NLGElement vp1 = sentences[i - 1].getFeatureAsElement("verb_phrase");
            NLGElement vp2 = sentences[i].getFeatureAsElement("verb_phrase");
            equal = vp1.getFeatureAsElementList("postmodifiers").equals(vp2.getFeatureAsElementList("postmodifiers")) && vp1.getFeatureAsElementList("premodifiers").equals(vp2.getFeatureAsElementList("premodifiers"));
        }
        return equal;
    }

    public static List<PhraseSet> leftPeriphery(NLGElement ... sentences) {
        ArrayList<PhraseSet> funcsets = new ArrayList<PhraseSet>();
        PhraseSet cue = new PhraseSet(DiscourseFunction.CUE_PHRASE, new NLGElement[0]);
        PhraseSet front = new PhraseSet(DiscourseFunction.FRONT_MODIFIER, new NLGElement[0]);
        PhraseSet subj = new PhraseSet(DiscourseFunction.SUBJECT, new NLGElement[0]);
        for (NLGElement s : sentences) {
            if (s.hasFeature("cue_phrase")) {
                cue.addPhrases(s.getFeatureAsElementList("cue_phrase"));
            }
            if (s.hasFeature("front_modifiers")) {
                front.addPhrases(s.getFeatureAsElementList("front_modifiers"));
            }
            if (!s.hasFeature("subjects")) continue;
            subj.addPhrases(s.getFeatureAsElementList("subjects"));
        }
        funcsets.add(cue);
        funcsets.add(front);
        funcsets.add(subj);
        return funcsets;
    }

    public static List<PhraseSet> rightPeriphery(NLGElement ... sentences) {
        ArrayList<PhraseSet> funcsets = new ArrayList<PhraseSet>();
        PhraseSet comps = new PhraseSet(DiscourseFunction.OBJECT, new NLGElement[0]);
        PhraseSet pmods = new PhraseSet(DiscourseFunction.POST_MODIFIER, new NLGElement[0]);
        for (NLGElement s : sentences) {
            NLGElement vp = s.getFeatureAsElement("verb_phrase");
            if (vp != null) {
                if (vp.hasFeature("complements")) {
                    comps.addPhrases(vp.getFeatureAsElementList("complements"));
                }
                if (vp.hasFeature("postmodifiers")) {
                    pmods.addPhrases(vp.getFeatureAsElementList("postmodifiers"));
                }
            }
            if (!s.hasFeature("postmodifiers")) continue;
            pmods.addPhrases(s.getFeatureAsElementList("postmodifiers"));
        }
        funcsets.add(comps);
        funcsets.add(pmods);
        return funcsets;
    }

    public static boolean nonePassive(NLGElement ... sentences) {
        boolean nopass = true;
        for (int i = 0; i < sentences.length && nopass; ++i) {
            nopass = sentences[i].getFeatureAsBoolean("passive") == false;
        }
        return nopass;
    }
}

