/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.aggregation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import simplenlg.features.DiscourseFunction;
import simplenlg.framework.NLGElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhraseSet {
    private DiscourseFunction function;
    private List<NLGElement> phrases;

    public PhraseSet(DiscourseFunction function, NLGElement ... phrases) {
        this.function = function;
        this.phrases = new ArrayList<NLGElement>(Arrays.asList(phrases));
    }

    public void addPhrase(NLGElement phrase) {
        this.phrases.add(phrase);
    }

    public void addPhrases(Collection<NLGElement> phrases) {
        this.phrases.addAll(phrases);
    }

    public DiscourseFunction getFunction() {
        return this.function;
    }

    public void elideRightmost() {
        for (int i = 1; i < this.phrases.size(); ++i) {
            NLGElement phrase = this.phrases.get(i);
            if (phrase == null) continue;
            phrase.setFeature("elided", true);
        }
    }

    public void elideLeftmost() {
        for (int i = this.phrases.size() - 2; i >= 0; --i) {
            NLGElement phrase = this.phrases.get(i);
            if (phrase == null) continue;
            phrase.setFeature("elided", true);
        }
    }

    public boolean lemmaIdentical() {
        boolean ident = !this.phrases.isEmpty();
        for (int i = 1; i < this.phrases.size() && ident; ++i) {
            NLGElement rightHead;
            NLGElement left = this.phrases.get(i - 1);
            NLGElement right = this.phrases.get(i);
            if (left == null || right == null) continue;
            NLGElement leftHead = left.getFeatureAsElement("head");
            ident = leftHead == (rightHead = right.getFeatureAsElement("head")) || leftHead.equals(rightHead);
        }
        return ident;
    }

    public boolean formIdentical() {
        boolean ident = !this.phrases.isEmpty();
        for (int i = 1; i < this.phrases.size() && ident; ++i) {
            NLGElement left = this.phrases.get(i - 1);
            NLGElement right = this.phrases.get(i);
            if (left == null || right == null) continue;
            ident = left.equals(right);
        }
        return ident;
    }
}

