/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.format.english;

import java.util.ArrayList;
import java.util.List;
import simplenlg.format.english.NumberedPrefix;
import simplenlg.framework.CoordinatedPhraseElement;
import simplenlg.framework.DocumentCategory;
import simplenlg.framework.DocumentElement;
import simplenlg.framework.ElementCategory;
import simplenlg.framework.ListElement;
import simplenlg.framework.NLGElement;
import simplenlg.framework.NLGModule;
import simplenlg.framework.StringElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextFormatter
extends NLGModule {
    private static NumberedPrefix numberedPrefix = new NumberedPrefix();

    @Override
    public void initialise() {
    }

    @Override
    public NLGElement realise(NLGElement element) {
        NLGElement realisedComponent = null;
        StringBuffer realisation = new StringBuffer();
        if (element != null) {
            ElementCategory category = element.getCategory();
            List<NLGElement> components = element.getChildren();
            if (element instanceof StringElement) {
                realisation.append(element.getRealisation());
            } else if (category instanceof DocumentCategory) {
                String title = element instanceof DocumentElement ? ((DocumentElement)element).getTitle() : null;
                switch ((DocumentCategory)category) {
                    case DOCUMENT: {
                        this.appendTitle(realisation, title, 2);
                        this.realiseSubComponents(realisation, components);
                        break;
                    }
                    case SECTION: {
                        this.appendTitle(realisation, title, 1);
                        this.realiseSubComponents(realisation, components);
                        break;
                    }
                    case LIST: {
                        this.realiseSubComponents(realisation, components);
                        break;
                    }
                    case ENUMERATED_LIST: {
                        numberedPrefix.upALevel();
                        if (title != null) {
                            realisation.append(title).append('\n');
                        }
                        if (null != components && 0 < components.size()) {
                            realisedComponent = this.realise(components.get(0));
                            if (realisedComponent != null) {
                                realisation.append(realisedComponent.getRealisation());
                            }
                            for (int i = 1; i < components.size(); ++i) {
                                if (realisedComponent != null && !realisedComponent.getRealisation().endsWith("\n")) {
                                    realisation.append(' ');
                                }
                                if (components.get(i).getParent().getCategory() == DocumentCategory.ENUMERATED_LIST) {
                                    numberedPrefix.increment();
                                }
                                if ((realisedComponent = this.realise(components.get(i))) == null) continue;
                                realisation.append(realisedComponent.getRealisation());
                            }
                        }
                        numberedPrefix.downALevel();
                        break;
                    }
                    case PARAGRAPH: {
                        if (null != components && 0 < components.size()) {
                            realisedComponent = this.realise(components.get(0));
                            if (realisedComponent != null) {
                                realisation.append(realisedComponent.getRealisation());
                            }
                            for (int i = 1; i < components.size(); ++i) {
                                if (realisedComponent != null) {
                                    realisation.append(' ');
                                }
                                if ((realisedComponent = this.realise(components.get(i))) == null) continue;
                                realisation.append(realisedComponent.getRealisation());
                            }
                        }
                        realisation.append("\n\n");
                        break;
                    }
                    case SENTENCE: {
                        realisation.append(element.getRealisation());
                        break;
                    }
                    case LIST_ITEM: {
                        if (element.getParent() != null) {
                            if (element.getParent().getCategory() == DocumentCategory.LIST) {
                                realisation.append(" * ");
                            } else if (element.getParent().getCategory() == DocumentCategory.ENUMERATED_LIST) {
                                realisation.append(numberedPrefix.getPrefix() + " - ");
                            }
                        }
                        for (NLGElement eachComponent : components) {
                            realisedComponent = this.realise(eachComponent);
                            if (realisedComponent == null) continue;
                            realisation.append(realisedComponent.getRealisation());
                            if (components.indexOf(eachComponent) >= components.size() - 1) continue;
                            realisation.append(' ');
                        }
                        realisation.append("\n");
                    }
                }
            } else if (element instanceof ListElement || element instanceof CoordinatedPhraseElement) {
                for (NLGElement eachComponent : components) {
                    realisedComponent = this.realise(eachComponent);
                    if (realisedComponent == null) continue;
                    realisation.append(realisedComponent.getRealisation()).append(' ');
                }
            }
        }
        return new StringElement(realisation.toString());
    }

    private void realiseSubComponents(StringBuffer realisation, List<NLGElement> components) {
        for (NLGElement eachComponent : components) {
            NLGElement realisedComponent = this.realise(eachComponent);
            if (realisedComponent == null) continue;
            realisation.append(realisedComponent.getRealisation());
        }
    }

    private void appendTitle(StringBuffer realisation, String title, int numberOfLineBreaksAfterTitle) {
        if (title != null && !title.isEmpty()) {
            realisation.append(title);
            for (int i = 0; i < numberOfLineBreaksAfterTitle; ++i) {
                realisation.append("\n");
            }
        }
    }

    @Override
    public List<NLGElement> realise(List<NLGElement> elements) {
        ArrayList<NLGElement> realisedList = new ArrayList<NLGElement>();
        if (elements != null) {
            for (NLGElement eachElement : elements) {
                realisedList.add(this.realise(eachElement));
            }
        }
        return realisedList;
    }
}

