/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.syntax.english;

import java.util.List;
import simplenlg.features.DiscourseFunction;
import simplenlg.framework.CoordinatedPhraseElement;
import simplenlg.framework.InflectedWordElement;
import simplenlg.framework.LexicalCategory;
import simplenlg.framework.ListElement;
import simplenlg.framework.NLGElement;
import simplenlg.framework.PhraseCategory;
import simplenlg.framework.WordElement;
import simplenlg.syntax.english.PhraseHelper;
import simplenlg.syntax.english.SyntaxProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class CoordinatedPhraseHelper {
    CoordinatedPhraseHelper() {
    }

    static NLGElement realise(SyntaxProcessor parent, CoordinatedPhraseElement phrase) {
        ListElement realisedElement = null;
        if (phrase != null) {
            realisedElement = new ListElement();
            PhraseHelper.realiseList(parent, realisedElement, phrase.getPreModifiers(), DiscourseFunction.PRE_MODIFIER);
            CoordinatedPhraseElement coordinated = new CoordinatedPhraseElement();
            List<NLGElement> children = phrase.getChildren();
            String conjunction = phrase.getFeatureAsString("conjunction");
            coordinated.setFeature("conjunction", conjunction);
            coordinated.setFeature("conjunction_type", phrase.getFeature("conjunction_type"));
            InflectedWordElement conjunctionElement = null;
            if (children != null && children.size() > 0) {
                if (phrase.getFeatureAsBoolean("raise_specifier").booleanValue()) {
                    CoordinatedPhraseHelper.raiseSpecifier(children);
                }
                NLGElement child = phrase.getLastCoordinate();
                child.setFeature("possessive", phrase.getFeature("possessive"));
                child = children.get(0);
                CoordinatedPhraseHelper.setChildFeatures(phrase, child);
                coordinated.addCoordinate(parent.realise(child));
                for (int index = 1; index < children.size(); ++index) {
                    child = children.get(index);
                    CoordinatedPhraseHelper.setChildFeatures(phrase, child);
                    if (phrase.getFeatureAsBoolean("aggregate_auxiliary").booleanValue()) {
                        child.setFeature("realise_auxiliary", false);
                    }
                    if (child.isA(PhraseCategory.CLAUSE)) {
                        child.setFeature("suppressed_complementiser", phrase.getFeature("suppressed_complementiser"));
                    }
                    if (conjunction != null && conjunction.length() > 0) {
                        conjunctionElement = new InflectedWordElement(conjunction, LexicalCategory.CONJUNCTION);
                        conjunctionElement.setFeature("discourse_function", (Object)DiscourseFunction.CONJUNCTION);
                        coordinated.addCoordinate(conjunctionElement);
                    }
                    coordinated.addCoordinate(parent.realise(child));
                }
                realisedElement.addComponent(coordinated);
            }
            PhraseHelper.realiseList(parent, realisedElement, phrase.getPostModifiers(), DiscourseFunction.POST_MODIFIER);
            PhraseHelper.realiseList(parent, realisedElement, phrase.getComplements(), DiscourseFunction.COMPLEMENT);
        }
        return realisedElement;
    }

    private static void setChildFeatures(CoordinatedPhraseElement phrase, NLGElement child) {
        if (phrase.hasFeature("progressive")) {
            child.setFeature("progressive", phrase.getFeature("progressive"));
        }
        if (phrase.hasFeature("perfect")) {
            child.setFeature("perfect", phrase.getFeature("perfect"));
        }
        if (phrase.hasFeature("specifier")) {
            child.setFeature("specifier", phrase.getFeature("specifier"));
        }
        if (phrase.hasFeature("gender")) {
            child.setFeature("gender", phrase.getFeature("gender"));
        }
        if (phrase.hasFeature("number")) {
            child.setFeature("number", phrase.getFeature("number"));
        }
        if (phrase.hasFeature("tense")) {
            child.setFeature("tense", phrase.getFeature("tense"));
        }
        if (phrase.hasFeature("person")) {
            child.setFeature("person", phrase.getFeature("person"));
        }
        if (phrase.hasFeature("negated")) {
            child.setFeature("negated", phrase.getFeature("negated"));
        }
        if (phrase.hasFeature("modal")) {
            child.setFeature("modal", phrase.getFeature("modal"));
        }
        if (phrase.hasFeature("discourse_function")) {
            child.setFeature("discourse_function", phrase.getFeature("discourse_function"));
        }
        if (phrase.hasFeature("form")) {
            child.setFeature("form", phrase.getFeature("form"));
        }
        if (phrase.hasFeature("clause_status")) {
            child.setFeature("clause_status", phrase.getFeature("clause_status"));
        }
        if (phrase.hasFeature("interrogative_type")) {
            child.setFeature("ignore_modal", true);
        }
    }

    private static void raiseSpecifier(List<NLGElement> children) {
        boolean allMatch = true;
        NLGElement child = children.get(0);
        NLGElement specifier = null;
        String test = null;
        if (child != null) {
            specifier = child.getFeatureAsElement("specifier");
            if (specifier != null) {
                String string = test = specifier instanceof WordElement ? ((WordElement)specifier).getBaseForm() : specifier.getFeatureAsString("base_form");
            }
            if (test != null) {
                for (int index = 1; index < children.size() && allMatch; ++index) {
                    String childForm;
                    child = children.get(index);
                    if (child == null) {
                        allMatch = false;
                        continue;
                    }
                    specifier = child.getFeatureAsElement("specifier");
                    String string = childForm = specifier instanceof WordElement ? ((WordElement)specifier).getBaseForm() : specifier.getFeatureAsString("base_form");
                    if (test.equals(childForm)) continue;
                    allMatch = false;
                }
                if (allMatch) {
                    for (int eachChild = 1; eachChild < children.size(); ++eachChild) {
                        child = children.get(eachChild);
                        child.setFeature("raised", true);
                    }
                }
            }
        }
    }
}

