/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.xmlrealiser;

import java.io.Reader;
import java.util.ArrayList;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import simplenlg.features.ClauseStatus;
import simplenlg.features.DiscourseFunction;
import simplenlg.features.Form;
import simplenlg.features.Gender;
import simplenlg.features.Inflection;
import simplenlg.features.InterrogativeType;
import simplenlg.features.NumberAgreement;
import simplenlg.features.Person;
import simplenlg.features.Tense;
import simplenlg.framework.CoordinatedPhraseElement;
import simplenlg.framework.DocumentCategory;
import simplenlg.framework.DocumentElement;
import simplenlg.framework.ElementCategory;
import simplenlg.framework.InflectedWordElement;
import simplenlg.framework.LexicalCategory;
import simplenlg.framework.NLGElement;
import simplenlg.framework.NLGFactory;
import simplenlg.framework.PhraseCategory;
import simplenlg.framework.PhraseElement;
import simplenlg.framework.WordElement;
import simplenlg.lexicon.Lexicon;
import simplenlg.phrasespec.AdjPhraseSpec;
import simplenlg.phrasespec.AdvPhraseSpec;
import simplenlg.phrasespec.NPPhraseSpec;
import simplenlg.phrasespec.PPPhraseSpec;
import simplenlg.phrasespec.SPhraseSpec;
import simplenlg.phrasespec.VPPhraseSpec;
import simplenlg.xmlrealiser.XMLRealiserException;
import simplenlg.xmlrealiser.wrapper.NLGSpec;
import simplenlg.xmlrealiser.wrapper.XmlAdjPhraseSpec;
import simplenlg.xmlrealiser.wrapper.XmlAdvPhraseSpec;
import simplenlg.xmlrealiser.wrapper.XmlCoordinatedPhraseElement;
import simplenlg.xmlrealiser.wrapper.XmlDocumentCategory;
import simplenlg.xmlrealiser.wrapper.XmlDocumentElement;
import simplenlg.xmlrealiser.wrapper.XmlLexicalCategory;
import simplenlg.xmlrealiser.wrapper.XmlNLGElement;
import simplenlg.xmlrealiser.wrapper.XmlNPPhraseSpec;
import simplenlg.xmlrealiser.wrapper.XmlPPPhraseSpec;
import simplenlg.xmlrealiser.wrapper.XmlPhraseCategory;
import simplenlg.xmlrealiser.wrapper.XmlPhraseElement;
import simplenlg.xmlrealiser.wrapper.XmlSPhraseSpec;
import simplenlg.xmlrealiser.wrapper.XmlStringElement;
import simplenlg.xmlrealiser.wrapper.XmlVPPhraseSpec;
import simplenlg.xmlrealiser.wrapper.XmlWordElement;

public class UnWrapper {
    NLGFactory factory = null;

    public static NLGSpec getNLGSpec(Reader xmlReader) throws XMLRealiserException {
        NLGSpec wt = null;
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{NLGSpec.class});
            Unmarshaller u = jc.createUnmarshaller();
            Object obj = u.unmarshal(xmlReader);
            if (obj instanceof NLGSpec) {
                wt = (NLGSpec)obj;
            }
        }
        catch (Throwable e) {
            throw new XMLRealiserException("XML unmarshal error", e);
        }
        return wt;
    }

    public UnWrapper(Lexicon lexicon) {
        this.factory = new NLGFactory(lexicon);
    }

    public DocumentElement UnwrapDocumentElement(XmlDocumentElement wt) {
        DocumentElement t = this.factory.createDocument();
        if (wt.getCat() != null) {
            t.setCategory(Enum.valueOf(DocumentCategory.class, wt.getCat().toString()));
        }
        if (wt.getTitle() != null) {
            t.setTitle(wt.getTitle());
        }
        for (XmlNLGElement wp : wt.getChild()) {
            NLGElement p = this.UnwrapNLGElement(wp);
            t.addComponent(p);
        }
        return t;
    }

    public NLGElement UnwrapNLGElement(XmlNLGElement wps) {
        if (wps == null) {
            return null;
        }
        if (wps instanceof XmlDocumentElement) {
            return this.UnwrapDocumentElement((XmlDocumentElement)wps);
        }
        NLGElement cp = this.UnwrapCoordinatePhraseSpec(wps);
        if (cp != null) {
            return cp;
        }
        if (wps instanceof XmlStringElement) {
            XmlStringElement wp = (XmlStringElement)wps;
            NLGElement p = this.factory.createStringElement(wp.getVal());
            return p;
        }
        if (wps instanceof XmlWordElement) {
            return this.UnwrapWordElement((XmlWordElement)wps);
        }
        if (wps instanceof XmlSPhraseSpec) {
            XmlSPhraseSpec wp = (XmlSPhraseSpec)wps;
            SPhraseSpec sp = this.factory.createClause();
            NLGElement vp = null;
            ArrayList<NLGElement> subjects = new ArrayList<NLGElement>();
            for (XmlNLGElement p : wp.getSubj()) {
                NLGElement p1 = this.UnwrapNLGElement(p);
                this.checkFunction(DiscourseFunction.SUBJECT, p1);
                subjects.add(p1);
            }
            if (subjects.size() > 0) {
                sp.setFeature("subjects", subjects);
            }
            if (wp.getVp() != null) {
                vp = this.UnwrapNLGElement(wp.getVp());
                sp.setVerbPhrase(vp);
            }
            if (wp.getCuePhrase() != null) {
                NLGElement cue = this.UnwrapNLGElement(wp.getCuePhrase());
                cue.setFeature("discourse_function", (Object)DiscourseFunction.CUE_PHRASE);
                sp.setFeature("cue_phrase", cue);
            }
            if (wp.getCOMPLEMENTISER() != null) {
                sp.setFeature("complementiser", wp.getCOMPLEMENTISER());
            }
            this.setSFeatures(wp, sp, vp);
            this.UnwrapPhraseComponents(sp, wps);
            return sp;
        }
        if (wps instanceof XmlPhraseElement) {
            Boolean appositive;
            XmlPhraseElement wp;
            XmlPhraseElement we = (XmlPhraseElement)wps;
            PhraseElement hp = null;
            XmlWordElement w = we.getHead();
            NLGElement head = this.UnwrapWordElement(w);
            if (wps instanceof XmlNPPhraseSpec) {
                wp = (XmlNPPhraseSpec)wps;
                NPPhraseSpec p = this.factory.createNounPhrase(head);
                hp = p;
                if (((XmlNPPhraseSpec)wp).getSpec() != null) {
                    XmlNLGElement spec = ((XmlNPPhraseSpec)wp).getSpec();
                    if (spec instanceof XmlWordElement) {
                        WordElement specifier = (WordElement)this.UnwrapWordElement((XmlWordElement)spec);
                        if (specifier != null) {
                            p.setSpecifier(specifier);
                        }
                    } else {
                        p.setSpecifier(this.UnwrapNLGElement(spec));
                    }
                }
                this.setNPFeatures((XmlNPPhraseSpec)wp, p);
            } else if (wps instanceof XmlAdjPhraseSpec) {
                wp = (XmlAdjPhraseSpec)wps;
                AdjPhraseSpec p = this.factory.createAdjectivePhrase(head);
                hp = p;
                p.setFeature("is_comparative", ((XmlAdjPhraseSpec)wp).isISCOMPARATIVE());
                p.setFeature("is_superlative", ((XmlAdjPhraseSpec)wp).isISSUPERLATIVE());
            } else if (wps instanceof XmlPPPhraseSpec) {
                PPPhraseSpec p = this.factory.createPrepositionPhrase(head);
                hp = p;
            } else if (wps instanceof XmlAdvPhraseSpec) {
                wp = (XmlAdvPhraseSpec)wps;
                AdvPhraseSpec p = this.factory.createAdverbPhrase();
                p.setHead(head);
                hp = p;
                p.setFeature("is_comparative", ((XmlAdvPhraseSpec)wp).isISCOMPARATIVE());
                p.setFeature("is_superlative", ((XmlAdvPhraseSpec)wp).isISSUPERLATIVE());
            } else if (wps instanceof XmlVPPhraseSpec) {
                wp = (XmlVPPhraseSpec)wps;
                VPPhraseSpec p = this.factory.createVerbPhrase(head);
                hp = p;
                this.setVPFeatures((XmlVPPhraseSpec)wp, p);
            }
            this.UnwrapPhraseComponents(hp, wps);
            if (we.getDiscourseFunction() != null) {
                hp.setFeature("discourse_function", (Object)Enum.valueOf(DiscourseFunction.class, we.getDiscourseFunction().toString()));
            }
            if ((appositive = we.isAppositive()) != null) {
                hp.setFeature("appositive", appositive);
            }
            return hp;
        }
        return null;
    }

    public void UnwrapPhraseComponents(PhraseElement hp, XmlNLGElement wps) {
        if (hp != null && wps != null) {
            NLGElement p1;
            XmlPhraseElement wp = (XmlPhraseElement)wps;
            for (XmlNLGElement p : wp.getFrontMod()) {
                p1 = this.UnwrapNLGElement(p);
                this.checkFunction(DiscourseFunction.FRONT_MODIFIER, p1);
                if (p1 == null) continue;
                hp.addFrontModifier(p1);
            }
            for (XmlNLGElement p : wp.getPreMod()) {
                p1 = this.UnwrapNLGElement(p);
                this.checkFunction(DiscourseFunction.PRE_MODIFIER, p1);
                if (p1 == null) continue;
                hp.addPreModifier(p1);
            }
            for (XmlNLGElement p : wp.getPostMod()) {
                p1 = this.UnwrapNLGElement(p);
                this.checkFunction(DiscourseFunction.POST_MODIFIER, p1);
                if (p1 == null) continue;
                hp.addPostModifier(p1);
            }
            for (XmlNLGElement p : wp.getCompl()) {
                p1 = this.UnwrapNLGElement(p);
                this.checkFunction(DiscourseFunction.OBJECT, p1);
                if (p1 == null) continue;
                hp.addComplement(p1);
            }
        }
    }

    public NLGElement UnwrapCoordinatePhraseSpec(XmlNLGElement wps) {
        CoordinatedPhraseElement ret = null;
        if (wps instanceof XmlCoordinatedPhraseElement) {
            String s;
            XmlCoordinatedPhraseElement wp = (XmlCoordinatedPhraseElement)wps;
            CoordinatedPhraseElement cp = new CoordinatedPhraseElement();
            ElementCategory cat = this.UnwrapCategory((Object)wp.getCat());
            if (cat != null && cat instanceof PhraseCategory) {
                cp.setCategory(cat);
            }
            if (wp.getConj() != null && (s = wp.getConj()) != null) {
                cp.setConjunction(s);
            }
            this.setCoordinatedPhraseFeatures(wp, cp);
            for (XmlNLGElement p : wp.getCoord()) {
                NLGElement p1 = this.UnwrapNLGElement(p);
                if (p1 == null) continue;
                cp.addCoordinate(p1);
            }
            ret = cp;
        }
        return ret;
    }

    private NLGElement UnwrapWordElement(XmlWordElement wordElement) {
        NLGElement word = null;
        if (wordElement != null) {
            if (Boolean.TRUE.equals(wordElement.isCanned())) {
                word = this.factory.createStringElement(wordElement.getBase());
            } else {
                String baseForm;
                LexicalCategory lexCat = LexicalCategory.ANY;
                ElementCategory cat = this.UnwrapCategory((Object)wordElement.getCat());
                if (cat != null && cat instanceof LexicalCategory) {
                    lexCat = (LexicalCategory)cat;
                }
                if ((baseForm = wordElement.getBase()) != null) {
                    word = this.factory.createWord(baseForm, lexCat);
                    if (word instanceof InflectedWordElement && ((InflectedWordElement)word).getBaseWord().getBaseForm().isEmpty()) {
                        word = null;
                    } else if (word instanceof WordElement) {
                        WordElement we = (WordElement)word;
                        if (wordElement.getVar() != null) {
                            Inflection defaultInflection = Enum.valueOf(Inflection.class, wordElement.getVar().toString());
                            we.setDefaultInflectionalVariant(defaultInflection);
                        }
                        if (!baseForm.matches(we.getBaseForm())) {
                            we.setDefaultSpellingVariant(baseForm);
                        }
                    }
                }
            }
        }
        return word;
    }

    private ElementCategory UnwrapCategory(Object cat) {
        if (cat == null) {
            return null;
        }
        if (cat.getClass().equals(XmlLexicalCategory.class)) {
            return Enum.valueOf(LexicalCategory.class, cat.toString());
        }
        if (cat.getClass().equals(XmlPhraseCategory.class)) {
            return Enum.valueOf(PhraseCategory.class, cat.toString());
        }
        if (cat.getClass().equals(XmlDocumentCategory.class)) {
            return Enum.valueOf(DocumentCategory.class, cat.toString());
        }
        return null;
    }

    private void setCoordinatedPhraseFeatures(XmlCoordinatedPhraseElement wp, CoordinatedPhraseElement p) {
        if (wp.getPERSON() != null) {
            p.setFeature("person", (Object)wp.getPERSON());
        }
        if (wp.getTENSE() != null) {
            p.setFeature("tense", (Object)Enum.valueOf(Tense.class, wp.getTENSE().toString()));
        }
        if (wp.getMODAL() != null) {
            p.setFeature("modal", wp.getMODAL());
        }
        if (wp.getNUMBER() != null) {
            String numString = wp.getNUMBER().toString();
            NumberAgreement simplenlgNum = NumberAgreement.valueOf(numString);
            p.setFeature("number", (Object)simplenlgNum);
        }
        if (wp.getPERSON() != null) {
            String perString = wp.getPERSON().toString();
            Person simplenlgPers = Person.valueOf(perString);
            p.setFeature("person", (Object)simplenlgPers);
        }
        p.setFeature("appositive", wp.isAPPOSITIVE());
        p.setFeature("negated", wp.isNEGATED());
        p.setFeature("possessive", wp.isPOSSESSIVE());
        p.setFeature("progressive", wp.isPROGRESSIVE());
        p.setFeature("raise_specifier", wp.isRAISESPECIFIER());
        p.setFeature("suppressed_complementiser", wp.isSUPRESSEDCOMPLEMENTISER());
    }

    private void setNPFeatures(XmlNPPhraseSpec wp, NPPhraseSpec p) {
        if (wp.getNUMBER() != null) {
            String numString = wp.getNUMBER().toString();
            NumberAgreement simplenlgNum = NumberAgreement.valueOf(numString);
            p.setFeature("number", (Object)simplenlgNum);
        }
        if (wp.getPERSON() != null) {
            String perString = wp.getPERSON().toString();
            Person simplenlgPers = Person.valueOf(perString);
            p.setFeature("person", (Object)simplenlgPers);
        }
        if (wp.getGENDER() != null) {
            String genString = wp.getGENDER().toString();
            Gender simplenlgGen = Gender.valueOf(genString);
            p.setFeature("gender", (Object)simplenlgGen);
        }
        p.setFeature("elided", wp.isELIDED());
        p.setFeature("possessive", wp.isPOSSESSIVE());
        p.setFeature("pronominal", wp.isPRONOMINAL());
    }

    private void setVPFeatures(XmlVPPhraseSpec wp, VPPhraseSpec p) {
        if (wp.getFORM() != null) {
            p.setFeature("form", (Object)Enum.valueOf(Form.class, wp.getFORM().toString()));
        }
        if (wp.getPERSON() != null) {
            p.setFeature("person", (Object)wp.getPERSON());
        }
        if (wp.getTENSE() != null) {
            p.setFeature("tense", (Object)Enum.valueOf(Tense.class, wp.getTENSE().toString()));
        }
        if (wp.getMODAL() != null) {
            p.setFeature("modal", wp.getMODAL());
        }
        p.setFeature("aggregate_auxiliary", wp.isAGGREGATEAUXILIARY());
        p.setFeature("negated", wp.isNEGATED());
        p.setFeature("passive", wp.isPASSIVE());
        p.setFeature("perfect", wp.isPERFECT());
        p.setFeature("progressive", wp.isPROGRESSIVE());
        p.setFeature("suppress_genitive_in_gerund", wp.isSUPPRESSGENITIVEINGERUND());
        p.setFeature("suppressed_complementiser", wp.isSUPRESSEDCOMPLEMENTISER());
    }

    private void setSFeatures(XmlSPhraseSpec wp, SPhraseSpec sp, NLGElement vp) {
        if (wp.getCLAUSESTATUS() != null) {
            sp.setFeature("clause_status", (Object)Enum.valueOf(ClauseStatus.class, wp.getCLAUSESTATUS().toString()));
        }
        if (wp.getPERSON() != null) {
            sp.setFeature("person", (Object)Enum.valueOf(Person.class, wp.getPERSON().toString()));
        }
        if (wp.getFORM() != null) {
            sp.setFeature("form", (Object)Enum.valueOf(Form.class, wp.getFORM().toString()));
        }
        if (wp.getTENSE() != null) {
            sp.setFeature("tense", (Object)Enum.valueOf(Tense.class, wp.getTENSE().toString()));
        } else if (vp != null && vp.hasFeature("tense")) {
            sp.setFeature("tense", vp.getFeature("tense"));
        }
        if (wp.getMODAL() != null) {
            sp.setFeature("modal", wp.getMODAL());
        } else if (vp != null && vp.hasFeature("modal")) {
            sp.setFeature("modal", vp.getFeature("modal"));
        }
        if (wp.getINTERROGATIVETYPE() != null) {
            sp.setFeature("interrogative_type", (Object)Enum.valueOf(InterrogativeType.class, wp.getINTERROGATIVETYPE().toString()));
        } else if (vp != null && vp.hasFeature("interrogative_type")) {
            sp.setFeature("interrogative_type", vp.getFeature("interrogative_type"));
        }
        boolean sAggregateAuxiliary = wp.isAGGREGATEAUXILIARY() == null ? false : wp.isAGGREGATEAUXILIARY();
        boolean vAggregateAuxiliary = vp == null ? false : vp.getFeatureAsBoolean("aggregate_auxiliary");
        sp.setFeature("aggregate_auxiliary", sAggregateAuxiliary || vAggregateAuxiliary);
        boolean sPass = wp.isPASSIVE() == null ? false : wp.isPASSIVE();
        boolean vPass = vp == null ? false : vp.getFeatureAsBoolean("passive");
        sp.setFeature("passive", sPass || vPass);
        boolean sProg = wp.isPROGRESSIVE() == null ? false : wp.isPROGRESSIVE();
        boolean vProg = vp == null ? false : vp.getFeatureAsBoolean("progressive");
        sp.setFeature("progressive", sProg || vProg);
        boolean sPerf = wp.isPERFECT() == null ? false : wp.isPERFECT();
        boolean vPerf = vp == null ? false : vp.getFeatureAsBoolean("perfect");
        sp.setFeature("perfect", sPerf || vPerf);
        boolean sNeg = wp.isNEGATED() == null ? false : wp.isNEGATED();
        boolean vNeg = vp == null ? false : vp.getFeatureAsBoolean("negated");
        sp.setFeature("negated", sNeg || vNeg);
        boolean ssgg = wp.isSUPPRESSGENITIVEINGERUND() == null ? false : wp.isSUPPRESSGENITIVEINGERUND();
        boolean vsgg = vp == null ? false : vp.getFeatureAsBoolean("suppress_genitive_in_gerund");
        sp.setFeature("suppress_genitive_in_gerund", ssgg || vsgg);
        boolean ssc = wp.isSUPRESSEDCOMPLEMENTISER() == null ? false : wp.isSUPRESSEDCOMPLEMENTISER();
        boolean vsc = vp == null ? false : vp.getFeatureAsBoolean("suppressed_complementiser");
        sp.setFeature("suppressed_complementiser", ssc || vsc);
    }

    private void checkFunction(DiscourseFunction function, NLGElement phrase) {
        if (!phrase.hasFeature("discourse_function")) {
            phrase.setFeature("discourse_function", (Object)function);
        }
    }
}

