var Suggestions = new function() {
	var list = [];
	var hash = {};
	var cursor = hash;
	var entered = [];
	var lastState = '';
	var prepositions = ['to', 'at', 'about', 'around', 'in', 'on', 'off', 'under'];
	var articles = ['a', 'an', 'the'];
	
	recursivelyFix = function(obj) {
		var keys = Object.keys(obj);
		for (var i = 0; i < keys.length; i++) {
			var key = keys[i];
			var subkeys = Object.keys(obj[key]);
			if (obj != hash && subkeys.length > 0 && subkeys.length <= 1) {
				for (var j = 0; j < subkeys.length; j++) {
					var subkey = subkeys[j];
					obj[key + ' ' + subkey] = obj[key][subkey];
				}
				delete obj[key];
				return recursivelyFix(obj);
			}
		}
		var keys = Object.keys(obj);
		for (var i = 0; i < keys.length; i++) {
			recursivelyFix(obj[keys[i]]);
		}
	}

	this.buildCommandHash = function(commands, split) {
		split = typeof split !== 'undefined' ? split : 1;
		hash = {};
		cursor = hash;
		entered = [];
		if (split > 0) {
			for (var i = 0; i < commands.length; i++) {
				var cmd = commands[i];
				var words = cmd.split(' ');
				var here = hash;
				while (words.length > 0) {
					var word = words.shift();
					for (var s = 1; s < split; i++) {
						if (words.length == 0) break;
						word = word + ' ' + words.shift();
					}
					if (words.length > 0) {
						if (articles.indexOf(word.toLowerCase()) != -1) {
							word = word + ' ' + words.shift();
						} else if (prepositions.indexOf(words[0].toLowerCase()) != -1) {
							word = word + ' ' + words.shift();
						}
					}
					if (here[word] == null) {
						here[word] = {};
					}
					here = here[word];
				}
			}
			recursivelyFix(hash);
		} else {
			for (var i = 0; i < commands.length; i++) {
				hash[commands[i]] = {};
			}
		}
	}

	this.makeButtons = function(state) {
		if (state) {
			lastState = state;
		}
	    $('#gamefic_command').val('');
	    $('#keyboard').html('');
	    var keys = Object.keys(cursor);
	    if (lastState == "Active" || lastState == "") {
		    keys.sort();
	    }
	    for (var i = 0; i < keys.length; i++) {
	    	var key = keys[i];
	    	var btnClass = "phrase";
	    	if (Object.keys(cursor[key]).length == 0) {
	    		btnClass += " complete";
	    	}
	    	var btn = $('<button class="' + btnClass + '" type="button">' + key + (Object.keys(cursor[key]).length > 0 ? '...' : '') + '</button>');
	    	btn.val(key);
	    	$('#keyboard').append(btn);
	    }
		$('#gamefic_display').html('');
		for (var i = 0; i < entered.length; i++) {
			$('#gamefic_display').append('<span>' + entered[i] + '</span> ');
		}
		$('#gamefic_command').val(entered.join(' '));
	}
	this.back = function() {
		entered.pop();
		cursor = hash;
		for (var i = 0; i < entered.length; i++) {
			cursor = cursor[entered[i]];
		}		
	}
	this.type = function(text) {
		entered.push(text);
		cursor = cursor[text];
		Suggestions.makeButtons(lastState);
	}
}

$(function() {
	$('body').on('click', '#keyboard button.phrase', function() {
		Suggestions.type($(this).val());
		if ($('#gamefic_command').val()) {
			$('#back').addClass('on');
		} else {
			$('#back').removeClass('on');
		}
	});
	$('body').on('click', '#keyboard button.phrase.complete', function() {
		$('#back').removeClass('on');
		$('#gamefic_console form').submit();
		$('#command').val('');
	});
	$('#back').click(function() {
		Suggestions.back();
		Suggestions.makeButtons();
		if ($('#gamefic_command').val()) {
			$('#back').addClass('on');
		} else {
			$('#back').removeClass('on');
		}
	});	
});
