$(function() {
	var sceneHandlers = {
		'Activity': function(state) {
			var suggestions = [];
			state.suggestions.forEach(function(s) {
				suggestions.push(s);
			});
			$('.require_activity').removeClass('disabled');
			Suggestions.buildCommandHash(suggestions);
			Suggestions.makeButtons('');
		},
		'Pause': function(state) {
			$('#gamefic_output').append(
				'<p class="pause"><a href="#" rel="gamefic" data-command="Continue">Continue</a></p>'
			);
		},
		'MultipleChoice': function(state) {
			var ol = '<ol class="multiple_choice">';
			state.options.forEach(function(o) {
				var cls = '';
				if (state.entered && state.entered[o]) {
					cls = 'entered';
				}
				ol += '<li><a href="#" rel="gamefic" data-command="' + o + '" class="' + cls + '">' + o + '</a></li>';
			});
			ol += '</ol>';
			$('#gamefic_output').append(ol);
		},
		'YesOrNo': function(state) {
			var ol = '<ol class="multiple_choice">';
			['Yes', 'No'].forEach(function(o) {
				ol += '<li><a href="#" rel="gamefic" data-command="' + o + '">' + o + '</a></li>';
			});
			ol += '</ol>';
			$('#gamefic_output').append(ol);
		}
	}
	var resizeText = function() {
		if ($('#gamefic_output').html() == '') {
			$('#gamefic_output').hide();
		} else {
			$('#gamefic_output').show();
		}
		$('#gamefic_screen').css({
			width: $('#gamefic_background').width(),
			top: 'auto',
			bottom: 'auto'
		});
		if ($('#gamefic_screen').hasClass('align-to-bottom')) {
			if ($('#gamefic_console').hasClass('active')) {
				$('#gamefic_screen').css({
					bottom: ($('#gamefic_controls').height() + ($(document).height() * 0.05)),
				});
			} else {
				$('#gamefic_screen').css({
					bottom: ($(document).height() * 0.05)
				});
			}
		}
		if ($('#gamefic_screen').offset().top < 40) {
			var aTop = 95;
			if ($('#gamefic_console').hasClass('active')) {
				aTop = 65;
			}
			$('#gamefic_screen').css({
				top: 'calc(' + aTop + 'vh + 40px)'
			});	
		}
}
	$(window).resize(function() {
		resizeText();
	});
	$('#gamefic_controls form').submit(function(event) {
		event.preventDefault();
		var cmd = $('#gamefic_command').val();
		window.nextCommand = cmd;
		setTimeout("Gamefic.receive(window.nextCommand)", 250);
	$('#gamefic_command').val('');
	});
	$(document).on('click', 'a[rel="gamefic"]', function(event) {
		event.preventDefault();
		if (!$(this).hasClass('disabled')) {
			$('a[rel="gamefic"]').addClass('disabled');
			window.nextCommand = $(this).attr('data-command');
			setTimeout("Gamefic.receive(window.nextCommand)", 250);
			$.modal.close();
		} else if ($(this).hasClass('require_activity')) {
			if (Gamefic.state().scene != 'Conclusion') {
				$.toast({
					text: 'You need to complete the current scene first.',
					position: 'top-center',
					hideAfter: 2000
				});
			}
		}
	});
	$('#show_credits').click(function(event) {
		event.preventDefault();
		$('#credits').modal({ zIndex: 999 });
	});
	Gamefic.onUpdate((state) => {
		return new Promise((resolve) => {
			$('.require_activity').addClass('disabled');
			if (state.snapshot) {
				localStorage.setItem('snapshot', JSON.stringify(state.snapshot));
			}
			$('#gamefic_output').html(state.output);
			var f = (state.focus ? '[' + state.focus + ']' : '');
			$('#gamefic_focus').html(f);
			$('#gamefic_background').css({
				backgroundImage: (state.wallpaper ? 'url(media/' + state.wallpaper + ')' : 'none')
			});
			if (state.text_align == 'bottom') {
				$('#gamefic_screen').addClass('align-to-bottom');
			} else {
				$('#gamefic_screen').removeClass('align-to-bottom');
			}
			if (state.scene == 'Activity') {
				$('#gamefic_console').addClass('active');
			} else {
				$('#gamefic_console').removeClass('active');
			}
			var handler = sceneHandlers[state.scene]
			if (handler) {
				handler(state);
			} else {
				console.log('No handler for ' + state.scene);
			}
			resizeText();
			resolve(state);
		});
	});
	$('#gamefic_background').click(function() {
		$('body').toggleClass('image');
	})
	$('#settings').click(function(event) {
		event.stopPropagation();
		$('#menu').modal({ zIndex: 999 });
	});
	$('.new_game').click(function(event) {
		event.preventDefault();
		localStorage.removeItem('snapshot');
		window.location.reload();
	});
	/*Gamefic.enableLogging();
	if (Gamefic.canLog()) {
		Gamefic.logAlias(prompt('Please enter a name or alias:'));
	}*/
	Gamefic.start().then((state) => {
		var snap = localStorage.getItem('snapshot');
		if (snap) {
			Gamefic.restore('snapshot').then((response) => {
				Gamefic.update(response);
				$('#gamefic_output').append('Game restored to last available turn.');
				$('#gamefic_console').removeClass('loading');
				resizeText();
			}).catch((response) => {
				alert('The last snapshot is not compatible with this version of the game. Restarting...');
				$('#gamefic_console').removeClass('loading');
				resizeText();
			});
		} else {
			$('#gamefic_console').removeClass('loading');			
			resizeText();
		}
	});
});
