/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.app;

import com.fabriziopolo.textapp.InteractiveTextUi;
import com.fabriziopolo.textapp.TextAppController;
import com.fabriziopolo.textcraft.app.Game;
import com.fabriziopolo.textcraft.app.SimulationPlayer;
import com.fabriziopolo.textcraft.app.SinglePlayerGameState;
import com.fabriziopolo.textcraft.app.StatefulParserExecutor;
import com.fabriziopolo.textcraft.app.TextPrinter;
import com.fabriziopolo.textcraft.app.TextPrinterImpl;
import com.fabriziopolo.textcraft.app.ui.WeatherUiColorChanger;
import com.fabriziopolo.textcraft.peristence.Campaign;
import com.fabriziopolo.textcraft.peristence.LocalAppStoragePersistence;
import com.fabriziopolo.textcraft.peristence.Persistence;
import com.fabriziopolo.textcraft.peristence.Script;
import com.fabriziopolo.textcraft.player.Player;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.simulation.SinglePlayerSimulation;
import com.fabriziopolo.textcraft.states.singleplayer.EndGameState;
import com.fabriziopolo.textcraft.states.singleplayer.PauseGameState;
import com.fabriziopolo.textcraft.states.singleplayer.RequestSaveGameState;
import com.fabriziopolo.textcraft.text.FrameRenderer;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.function.Consumer;

public class TextCraftAppController
implements TextAppController {
    private static final int consoleWidth = 84;
    private static final int consoleHeight = 40;
    private static final int margin = 2;
    private Game game;
    private Campaign campaign = null;
    private Script script = new Script();
    private SinglePlayerGameState gameState = null;
    private SimulationPlayer simulationPlayer = null;
    private StatefulParserExecutor parserExecutor = new StatefulParserExecutor();
    private InteractiveTextUi ui = null;
    private Persistence persistence = null;
    private TextPrinter txt = null;
    private final FrameRenderer renderer = new FrameRenderer(80, 40);

    public TextCraftAppController(Game game) {
        this.setGame(game);
    }

    public void play() {
        this.endCurrentSimulation();
        this.setGameState(this.game.createInitialGameState());
        this.game.start(this);
        if (this.gameState != null) {
            this.simulationPlayer.play();
        }
    }

    @Override
    public void onText(String input) {
        this.executeInSimulation(simulation -> {
            if (!this.renderer.isBlocked()) {
                if (this.parseAppLevelCommands(input)) {
                    this.saveScript(true);
                    return;
                }
                this.script.addEntry(simulation.getCurrentFrame().frameNumber, input);
                boolean didAction = this.parserExecutor.onParsedInput(input, this);
                boolean isGamePaused = PauseGameState.isGamePaused(this.simulationPlayer.getSimulation().getCurrentFrame());
                if (isGamePaused) {
                    PauseGameState.requestContinueGame(this.simulationPlayer.getSimulation());
                    this.txt.println("The game has resumed.");
                    this.simulationPlayer.play();
                }
                if (didAction) {
                    this.simulationPlayer.advance();
                }
            } else {
                this.renderer.continueRendering(this.txt);
                if (!this.renderer.isBlocked()) {
                    if (this.isSimulationEnded(simulation.getCurrentFrame())) {
                        this.onSimulationEndedInternally((Simulation)simulation);
                    } else {
                        this.simulationPlayer.play();
                    }
                }
            }
        });
    }

    @Override
    public void setUi(InteractiveTextUi ui) {
        this.ui = ui;
        this.txt.setTextListener(ui);
        ui.setTitle(this.getFullExperienceTitle());
    }

    private boolean parseAppLevelCommands(String userInput) {
        return (userInput = userInput.toLowerCase()).equals("save script");
    }

    private void saveScript(boolean log) {
        block3: {
            String scriptFileName = "script " + ZonedDateTime.now().format(DateTimeFormatter.ofPattern("MM-dd-yy HH-mm-ss")) + ".bin";
            try {
                this.saveScript(scriptFileName);
                if (log) {
                    this.txt.println("Saved script to \"" + scriptFileName + "\".");
                }
            }
            catch (IOException ex) {
                if (!log) break block3;
                this.txt.println("Failed to save script due to " + ex.getMessage());
            }
        }
    }

    private void saveScript(String fileName) throws IOException {
        this.persistence.saveFileWithCampaign(this.campaign, this.script, fileName);
    }

    private boolean onFrame(SinglePlayerSimulation simulation, Frame prevFrame) {
        boolean isSimulationEnded = this.renderCurrentFrame(simulation, simulation.player);
        this.applyExternalSimulationUpdateSideEffects(prevFrame, simulation.getCurrentFrame());
        return isSimulationEnded;
    }

    private void onSimulationEndedInternally(Simulation simulation) {
        this.saveScript(false);
        this.ui.clearInput();
        this.play();
    }

    private boolean renderCurrentFrame(Simulation simulation, Player player) {
        Frame frame = simulation.getCurrentFrame();
        boolean simulationEnded = this.isSimulationEnded(frame);
        this.renderer.startRendering(frame, player, this.txt);
        if (this.renderer.isBlocked() || simulationEnded) {
            this.simulationPlayer.stop();
        }
        if (!this.renderer.isBlocked() && simulationEnded) {
            this.onSimulationEndedInternally(simulation);
        }
        return simulationEnded;
    }

    private boolean isSimulationEnded(Frame frame) {
        return EndGameState.isGameEnded(frame);
    }

    private void applyExternalSimulationUpdateSideEffects(Frame prevFrame, Frame frame) {
        if (this.gameState == null) {
            return;
        }
        if (RequestSaveGameState.isSaveRequested(frame)) {
            this.saveGame();
        }
        WeatherUiColorChanger.updateUiColor(this.ui, this.gameState.getPlayer(), frame);
    }

    private void endCurrentSimulation() {
        if (this.simulationPlayer == null) {
            return;
        }
        this.simulationPlayer.stop();
        this.simulationPlayer = null;
    }

    private String getFullExperienceTitle() {
        if (this.campaign != null) {
            return this.game.getFullGameName() + " - v" + this.game.getVersion() + " - " + this.campaign.campaignDisplayName;
        }
        return this.game.getFullGameName() + " - v" + this.game.getVersion();
    }

    private void saveGame() {
        try {
            this.txt.println("\nAuto-saving game...");
            this.persistence.saveWithPostfix(this.campaign, this.gameState, "(auto)");
            this.txt.println("Game saved.\n");
        }
        catch (Exception ex) {
            this.txt.println("Save failed.\n");
            ex.printStackTrace();
        }
    }

    @Override
    public void setGame(Game game) {
        this.game = Objects.requireNonNull(game);
        this.persistence = new LocalAppStoragePersistence(game);
        this.txt = new TextPrinterImpl(2, 82, this.persistence.getPersistentLog());
        this.setCampaign(null);
    }

    @Override
    public void setCampaign(Campaign campaign) {
        this.campaign = campaign;
        if (this.ui != null) {
            this.ui.setTitle(this.getFullExperienceTitle());
        }
    }

    @Override
    public void setGameState(SinglePlayerGameState gameState) {
        this.endCurrentSimulation();
        this.gameState = gameState;
        this.parserExecutor = new StatefulParserExecutor();
        this.script = new Script();
        this.simulationPlayer = new SimulationPlayer(gameState.getSimulation(), this::onFrame);
        this.simulationPlayer.play();
    }

    @Override
    public Game getGame() {
        return this.game;
    }

    @Override
    public Campaign getCampaign() {
        return this.campaign;
    }

    @Override
    public SinglePlayerGameState getGameState() {
        return this.gameState;
    }

    @Override
    public StatefulParserExecutor getParserExecutor() {
        return this.parserExecutor;
    }

    @Override
    public InteractiveTextUi getUi() {
        return this.ui;
    }

    @Override
    public Persistence getPersistence() {
        return this.persistence;
    }

    @Override
    public TextPrinter getTxt() {
        return this.txt;
    }

    @Override
    public void executeInSimulation(Consumer<Simulation> doMe) {
        this.simulationPlayer.execute(doMe);
    }

    @Override
    public void onClose(boolean save) {
        this.txt.closeLog();
        if (save) {
            try {
                this.persistence.saveWithPostfix(this.campaign, this.gameState, "(quit)");
            }
            catch (Exception ex) {
                this.txt.log("Failed to save on close. " + ex);
            }
        }
    }
}

