/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.commands;

import com.fabriziopolo.textapp.TextAppController;
import com.fabriziopolo.textcraft.commands.AbstractCommand;
import com.fabriziopolo.textcraft.commands.ActionsAndHints;
import com.fabriziopolo.textcraft.commands.Command;
import com.fabriziopolo.textcraft.commands.UserAction;
import com.fabriziopolo.textcraft.events.position.PlayerDebugExaminesNoun;
import com.fabriziopolo.textcraft.nlg.NounPhraseWithArticle;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.states.inventory.InventoryState;
import com.fabriziopolo.textcraft.states.position.PositionState;
import com.fabriziopolo.textcraft.text.TextMatcher;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class DebugExamineCommand
extends AbstractCommand {
    @Override
    public ActionsAndHints parse(String[] words, Command.Context context) {
        if (words.length < 1 || !words[0].toLowerCase().equals(this.getNameString())) {
            return null;
        }
        Frame frame = context.simulation.getCurrentFrame();
        if (words.length == 1) {
            return ActionsAndHints.action(new Result(context, PositionState.get(frame).getContainingRoom(context.player)));
        }
        PositionState position = PositionState.get(frame);
        Set<Noun> allNouns = position.getDesendentsOf(position.getContainingRoom(context.player));
        allNouns.addAll(InventoryState.getItemList(context.player, frame));
        List<TextMatcher.ResultWithData<Noun>> matches = DebugExamineCommand.matchOne(words, 1, allNouns, context.player, frame);
        ActionsAndHints results = new ActionsAndHints();
        results.addAllActions(matches.stream().map(match -> new Result(context, (Noun)match.data)).collect(Collectors.toList()));
        return results;
    }

    @Override
    public String getHelpString() {
        return null;
    }

    @Override
    public String getNameString() {
        return "#";
    }

    @Override
    public String getPurposeString() {
        return null;
    }

    @Override
    public boolean isVisibleInHelp() {
        return false;
    }

    class Result
    implements UserAction {
        private final Command.Context context;
        private final Noun objectToExamine;

        private Result(Command.Context context, Noun objectToExamine) {
            this.context = context;
            this.objectToExamine = objectToExamine;
        }

        @Override
        public String getDescription() {
            return "to debug examine " + NounPhraseWithArticle.the(this.context.player.getPerceptionOf(this.objectToExamine, this.context.simulation.getCurrentFrame())) + " #" + this.objectToExamine.hashCode();
        }

        @Override
        public void execute(TextAppController controller) {
            this.context.simulation.postEvent(new PlayerDebugExaminesNoun(this.objectToExamine));
        }

        @Override
        public boolean isValid(Frame frame) {
            return true;
        }
    }
}

