/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.commands;

import com.fabriziopolo.textapp.TextAppController;
import com.fabriziopolo.textcraft.commands.ActionsAndHints;
import com.fabriziopolo.textcraft.commands.Command;
import com.fabriziopolo.textcraft.commands.UserAction;
import com.fabriziopolo.textcraft.events.inventory.PlayerExaminesInventoryEvent;
import com.fabriziopolo.textcraft.simulation.Frame;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class InventoryCommand
implements Command {
    private static final List<String> INVENTORY_SYNONYMS = Arrays.asList("inventory", "i");

    @Override
    public ActionsAndHints parse(String[] words, Command.Context context) {
        if (words.length < 1) {
            return null;
        }
        String firstWord = words[0].toLowerCase();
        if (!INVENTORY_SYNONYMS.contains(firstWord)) {
            return null;
        }
        ArrayList<Result> results = new ArrayList<Result>();
        results.add(new Result(context));
        return new ActionsAndHints(results);
    }

    @Override
    public String getHelpString() {
        return "Type 'inventory' or 'i' to see what you're carrying.";
    }

    @Override
    public String getNameString() {
        return "inventory";
    }

    @Override
    public String getPurposeString() {
        return "List the items you're carrying. (i)";
    }

    @Override
    public boolean isVisibleInHelp() {
        return true;
    }

    class Result
    implements UserAction {
        private final Command.Context context;

        private Result(Command.Context context) {
            this.context = context;
        }

        @Override
        public String getDescription() {
            return "to take inventory";
        }

        @Override
        public void execute(TextAppController controller) {
            PlayerExaminesInventoryEvent takeInventoryEvent = new PlayerExaminesInventoryEvent(this.context.player);
            this.context.simulation.postEvent(takeInventoryEvent);
        }

        @Override
        public boolean isValid(Frame frame) {
            return true;
        }
    }
}

