/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.events.notification;

import com.fabriziopolo.textcraft.commands.Command;
import com.fabriziopolo.textcraft.events.notification.PlayerNotificationProvider;
import com.fabriziopolo.textcraft.nlg.Nlg;
import com.fabriziopolo.textcraft.nlg.Sentences;
import com.fabriziopolo.textcraft.simulation.Event;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.simulation.perception.Perceiver;
import com.fabriziopolo.textcraft.simulation.perception.PerceptionChannel;
import java.util.Objects;

public class PlayerNotificationEvent
implements Event {
    private final Noun player;
    private final PlayerNotificationProvider messageProvider;
    private final boolean isAlwaysPerceivable;
    private final Event.Style style;
    private final boolean blocking;

    private PlayerNotificationEvent(Noun player, PlayerNotificationProvider messageProvider, boolean alwaysPerceivable, Event.Style style) {
        this.player = player;
        this.messageProvider = messageProvider;
        this.isAlwaysPerceivable = alwaysPerceivable;
        this.style = style;
        this.blocking = false;
    }

    private PlayerNotificationEvent(Builder builder) {
        this.player = Objects.requireNonNull(builder.player);
        this.messageProvider = Objects.requireNonNull(builder.messageProvider);
        this.isAlwaysPerceivable = Objects.requireNonNull(builder.isAlwaysPerceivable);
        this.style = Objects.requireNonNull(builder.style);
        this.blocking = Objects.requireNonNull(builder.blocking);
    }

    @Override
    public boolean isBlocking() {
        return this.blocking;
    }

    @Override
    public Event.Style getStyle() {
        return this.style;
    }

    public static void post(Event.Style style, Noun player, Simulation simulation, String message) {
        simulation.postEvent(new PlayerNotificationEvent(player, new DefaultNotificationProvider(message), false, style));
    }

    public static void post(Noun player, Simulation simulation, String message) {
        simulation.postEvent(new PlayerNotificationEvent(player, new DefaultNotificationProvider(message), false, Event.Style.DEFAULT));
    }

    public static void postProminent(Noun player, Simulation simulation, String message) {
        simulation.postEvent(new PlayerNotificationEvent(player, new DefaultNotificationProvider(message), false, Event.Style.PROMINENT));
    }

    public static void post(Noun player, Simulation simulation, PlayerNotificationProvider messageProvider) {
        simulation.postEvent(new PlayerNotificationEvent(player, messageProvider, false, Event.Style.DEFAULT));
    }

    public static void post(Command.Context context, String message) {
        PlayerNotificationEvent.post((Noun)context.player, context.simulation, message);
    }

    public static void postProminent(Command.Context context, String message) {
        PlayerNotificationEvent.postProminent(context.player, context.simulation, message);
    }

    public static void postAlwaysPerceivable(Noun player, String message, Event.Style style, Simulation simulation) {
        simulation.postEvent(new PlayerNotificationEvent(player, new DefaultNotificationProvider(message), true, style));
    }

    public static void postAlwaysPerceivable(Noun player, String message, Simulation simulation) {
        PlayerNotificationEvent.postAlwaysPerceivable(player, message, Event.Style.DEFAULT, simulation);
    }

    public static void postAlwaysPerceivable(String message, Command.Context context) {
        PlayerNotificationEvent.postAlwaysPerceivable(context.player, message, context.simulation);
    }

    @Override
    public Sentences asPerceivedBy(Perceiver perceiver, Frame frame, PerceptionChannel channel) {
        if (perceiver == this.player) {
            return this.messageProvider.getMessage(perceiver, channel, frame);
        }
        return null;
    }

    @Override
    public boolean isAlwaysPerceivable() {
        return this.isAlwaysPerceivable;
    }

    public static final void postPressEnterToContinue(Noun player, Simulation simulation) {
        simulation.postEvent(PlayerNotificationEvent.getPressEnterToContinueEvent(player));
    }

    private static PlayerNotificationEvent getPressEnterToContinueEvent(Noun player) {
        return PlayerNotificationEvent.builder().setPlayer(player).setBlocking(true).setMessage("(press enter to continue)").setAlwaysPerceivable(true).build();
    }

    public static final Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Noun player;
        private PlayerNotificationProvider messageProvider;
        private boolean isAlwaysPerceivable = false;
        private Event.Style style = Event.Style.DEFAULT;
        private boolean blocking = false;

        public Builder setPlayer(Noun player) {
            this.player = player;
            return this;
        }

        public Builder setMessageProvider(PlayerNotificationProvider provider) {
            this.messageProvider = provider;
            return this;
        }

        public Builder setMessage(String message) {
            this.messageProvider = new DefaultNotificationProvider(message);
            return this;
        }

        public Builder setAlwaysPerceivable(boolean alwaysPerceivable) {
            this.isAlwaysPerceivable = alwaysPerceivable;
            return this;
        }

        public Builder setStyle(Event.Style style) {
            this.style = style;
            return this;
        }

        public Builder setBlocking(boolean blocking) {
            this.blocking = blocking;
            return this;
        }

        public PlayerNotificationEvent build() {
            return new PlayerNotificationEvent(this);
        }
    }

    private static final class DefaultNotificationProvider
    implements PlayerNotificationProvider {
        private final String message;

        private DefaultNotificationProvider(String message) {
            this.message = message;
        }

        public String toString() {
            return this.message;
        }

        @Override
        public Sentences getMessage(Perceiver perceiver, PerceptionChannel channel, Frame frame) {
            return Nlg.literalSentences(this.message);
        }
    }
}

