/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.objects;

import com.fabriziopolo.textcraft.nlg.MultipleSentences;
import com.fabriziopolo.textcraft.nlg.Nlg;
import com.fabriziopolo.textcraft.nlg.NounPhrase;
import com.fabriziopolo.textcraft.nlg.NounPhraseWithAdjective;
import com.fabriziopolo.textcraft.nlg.NounPhraseWithPrepositionalPhrase;
import com.fabriziopolo.textcraft.nlg.Prepositions;
import com.fabriziopolo.textcraft.nlg.PureAdjectivePhrase;
import com.fabriziopolo.textcraft.nlg.Sentences;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.perception.PerceptionChannel;
import com.fabriziopolo.textcraft.states.position.PositionState;
import com.fabriziopolo.textcraft.states.position.SpacialRelationship;
import com.fabriziopolo.textcraft.states.structure.StructureState;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;

public class LiquidContainerNoun
implements Noun {
    private final Noun containerDelegateNoun;

    public LiquidContainerNoun(Noun containerDelegateNoun) {
        this.containerDelegateNoun = Objects.requireNonNull(containerDelegateNoun);
    }

    @Override
    public NounPhrase asPerceivedBy(Noun perceiver, SpacialRelationship spacialRelationship, Frame frame, PerceptionChannel channel) {
        if (channel != PerceptionChannel.DEFAULT) {
            return null;
        }
        NounPhrase containerPerception = this.containerDelegateNoun.asPerceivedBy(perceiver, spacialRelationship, frame, channel);
        if (containerPerception == null) {
            return null;
        }
        if (frame == null) {
            return containerPerception;
        }
        Set<Noun> children = StructureState.getNonintegralChildren(this, frame);
        if (children == null || children.isEmpty()) {
            return this.getEmptyPerception(containerPerception);
        }
        ArrayList<Noun> contents = new ArrayList<Noun>(children);
        return this.getFullPerception(perceiver, channel, frame, containerPerception, contents);
    }

    protected NounPhrase getFullPerception(Noun object, PerceptionChannel channel, Frame frame, NounPhrase containerPerception, ArrayList<Noun> contents) {
        return NounPhraseWithPrepositionalPhrase.builder().setBaseNounPhrase(containerPerception).setPreposition(Prepositions.of).setObjectOfPreposition(contents.get(0).asPerceivedBy(object, null, frame, channel)).setMatchAsObjectOfPreposition(false).build();
    }

    protected NounPhrase getEmptyPerception(NounPhrase containerPerception) {
        return new NounPhraseWithAdjective(new PureAdjectivePhrase("empty"), containerPerception);
    }

    protected Sentences getVerboseEmptySentences(Noun object, PerceptionChannel channel, Frame frame) {
        return Nlg.literalSentences("It is empty.");
    }

    @Override
    public Sentences asVerboselyPerceivedBy(Noun perceiver, SpacialRelationship spacialRelationship, Frame frame, PerceptionChannel channel) {
        Sentences contentsDescription;
        if (channel != PerceptionChannel.DEFAULT) {
            return null;
        }
        Sentences containerDescription = this.containerDelegateNoun.asVerboselyPerceivedBy(perceiver, spacialRelationship, frame, channel);
        Set<Noun> children = PositionState.get(frame).getChildren(this);
        if (children == null || children.isEmpty()) {
            contentsDescription = this.getVerboseEmptySentences(perceiver, channel, frame);
        } else {
            ArrayList<Noun> contents = new ArrayList<Noun>(children);
            contentsDescription = Nlg.literalSentences("This " + this.containerDelegateNoun.asPerceivedBy(perceiver, spacialRelationship, frame, channel) + " contains " + contents.get(0).asPerceivedBy(perceiver, spacialRelationship, frame, channel) + ".");
        }
        return MultipleSentences.builder().add(containerDescription).add(contentsDescription).build();
    }
}

