/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.player;

import com.fabriziopolo.textcraft.events.notification.PlayerNotificationEvent;
import com.fabriziopolo.textcraft.nlg.Nlg;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.states.NotifyingNumberWithCauseState;
import com.fabriziopolo.textcraft.states.characterbio.oxygen.OxygenState;
import com.fabriziopolo.textcraft.states.water.SubmersionEffect;
import com.fabriziopolo.textcraft.text.Text;

public class SuffocationSubmersionEffect
implements SubmersionEffect {
    private final double dO2 = -0.05;

    @Override
    public void apply(Noun noun, boolean isSubmerged, Simulation simulation) {
        if (isSubmerged) {
            OxygenState.requestChange(noun, -0.05, Nlg.literalClause("you are under water"), simulation);
            this.notifyWithOxygenCountdown(noun, simulation);
        } else {
            OxygenState.requestChangeWithoutCause(noun, 1.0, simulation);
        }
    }

    private void notifyWithOxygenCountdown(Noun noun, Simulation simulation) {
        Frame frame = simulation.getCurrentFrame();
        NotifyingNumberWithCauseState.NumberWithCauses prevVwc = OxygenState.get(frame).get(noun);
        String prevNumber = "";
        if (prevVwc == null) {
            return;
        }
        double oxygenLevel = prevVwc.value;
        prevNumber = this.getCountdownNumber(oxygenLevel);
        double nextOxygenLevel = oxygenLevel + -0.05;
        String currNumber = this.getCountdownNumber(nextOxygenLevel = Math.min(1.0, Math.max(0.0, nextOxygenLevel)));
        if (!prevNumber.equals(currNumber)) {
            String mesage = currNumber + "..." + Text.getLineSeparator();
            PlayerNotificationEvent.post(noun, simulation, mesage);
        }
    }

    private String getCountdownNumber(double oxygen) {
        int count = (int)(oxygen * 10.0 + 0.999999);
        return Integer.valueOf(Math.min(11, Math.max(0, count))).toString();
    }

    private void notifyResurface(Noun noun, Simulation simulation) {
        NotifyingNumberWithCauseState.NumberWithCauses vwc = OxygenState.get(simulation.getCurrentFrame()).get(noun);
        if (vwc == null) {
            return;
        }
        if (vwc.value < 0.85) {
            PlayerNotificationEvent.post(noun, simulation, "You resurface and inhale. " + vwc.value);
        }
    }
}

