/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.states;

import com.fabriziopolo.textcraft.nlg.Conjunctions;
import com.fabriziopolo.textcraft.nlg.IndependentClause;
import com.fabriziopolo.textcraft.nlg.IndependentClausesWithConjunction;
import com.fabriziopolo.textcraft.nlg.Nlg;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.states.ValueState;
import java.io.Serializable;

public abstract class ValueWithCauseState<T>
extends ValueState<ValueWithCause<T>> {
    protected T combinePureValues(Noun noun, T t1, T t2, IndependentClause cause1, IndependentClause cause2, Simulation simulation) {
        return t2;
    }

    @Override
    protected abstract Class getStateKey();

    public IndependentClause getCause(Noun noun) {
        ValueWithCause valueWithCause = (ValueWithCause)this.get(noun);
        if (valueWithCause == null) {
            return null;
        }
        return valueWithCause.causeDescription;
    }

    public T getValue(Noun noun) {
        ValueWithCause valueWithCause = (ValueWithCause)this.get(noun);
        if (valueWithCause == null) {
            return null;
        }
        return valueWithCause.value;
    }

    @Override
    public ValueWithCause<T> combineValues(Noun noun, ValueWithCause<T> t1, ValueWithCause<T> t2, Simulation simulation) {
        if (t2 == null) {
            return t1;
        }
        if (t1 == null) {
            return t2;
        }
        Object combinedPureValues = this.combinePureValues(noun, t1.value, t2.value, t1.causeDescription, t2.causeDescription, simulation);
        IndependentClause newCauseDescription = IndependentClausesWithConjunction.combine(t1.causeDescription, Conjunctions.and, t2.causeDescription);
        return new ValueWithCause(combinedPureValues, newCauseDescription);
    }

    @Override
    protected void setUpdatedState(Simulation simulation, ValueState<ValueWithCause<T>> newStateBuilder) {
        this.getValueMap().forEach((noun, valueWithCause) -> newStateBuilder.set((Noun)noun, new ValueWithCause(valueWithCause.value, null)));
        newStateBuilder.applyUpdates(simulation);
    }

    public void requestChange(Simulation simulation, Noun noun, T value, IndependentClause cause) {
        this.requestChange(simulation, noun, new ValueWithCause<T>(value, cause));
    }

    public void requestChangeWithoutCause(Simulation simulation, Noun noun, T value) {
        this.requestChange(simulation, noun, new ValueWithCause<T>(value, null));
    }

    public static final class ValueWithCause<T>
    implements Serializable {
        public final T value;
        public final IndependentClause causeDescription;

        public ValueWithCause(T value, IndependentClause causeDescription) {
            this.value = value;
            this.causeDescription = causeDescription;
        }

        public static <T> ValueWithCause<T> create(T value, String literalDescriptionClause) {
            return new ValueWithCause<T>(value, Nlg.literalClause(literalDescriptionClause));
        }

        public static <T> ValueWithCause<T> create(T value) {
            return new ValueWithCause<T>(value, null);
        }

        public ValueWithCause<T> withNewValue(T value) {
            return new ValueWithCause<T>(value, this.causeDescription);
        }

        public String toString() {
            if (this.causeDescription == null) {
                return this.value.toString();
            }
            return this.value + " (because \"" + this.causeDescription + "\")";
        }
    }
}

