/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.states.position;

import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.states.position.SpacialRelationship;
import java.util.Objects;

public final class PathSegment {
    public final Noun startNoun;
    public final SpacialRelationship exitDirection;
    public final Noun exit;
    public final Noun entrance;
    public final SpacialRelationship entranceDirection;
    public final Noun endNoun;
    public final Pointing pointing;

    public PathSegment(Noun startRoom, Noun exitDirection, Noun exit, Noun entrance, Noun entranceDirection, Noun endRoom, Pointing pointing) {
        this.startNoun = startRoom;
        this.exitDirection = SpacialRelationship.of(exitDirection);
        this.exit = exit;
        this.entrance = entrance;
        this.entranceDirection = SpacialRelationship.of(entranceDirection);
        this.endNoun = endRoom;
        this.pointing = Objects.requireNonNull(pointing);
    }

    public PathSegment(Noun startRoom, SpacialRelationship exitDirection, Noun exit, Noun entrance, SpacialRelationship entranceDirection, Noun endRoom, Pointing pointing) {
        this.startNoun = startRoom;
        this.exitDirection = exitDirection;
        this.exit = exit;
        this.entrance = entrance;
        this.entranceDirection = entranceDirection;
        this.endNoun = endRoom;
        this.pointing = Objects.requireNonNull(pointing);
    }

    public boolean pointsOut() {
        return this.pointing == Pointing.OUT;
    }

    public boolean pointsIn() {
        return this.pointing == Pointing.IN;
    }

    public String toString() {
        return "ExitTo(" + this.endNoun + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PathSegment that = (PathSegment)o;
        if (!this.startNoun.equals(that.startNoun)) {
            return false;
        }
        if (this.exitDirection != null ? !this.exitDirection.equals(that.exitDirection) : that.exitDirection != null) {
            return false;
        }
        if (this.exit != null ? !this.exit.equals(that.exit) : that.exit != null) {
            return false;
        }
        if (this.entrance != null ? !this.entrance.equals(that.entrance) : that.entrance != null) {
            return false;
        }
        if (this.entranceDirection != null ? !this.entranceDirection.equals(that.entranceDirection) : that.entranceDirection != null) {
            return false;
        }
        return this.endNoun.equals(that.endNoun);
    }

    public int hashCode() {
        int result = this.startNoun.hashCode();
        result = 31 * result + (this.exitDirection != null ? this.exitDirection.hashCode() : 0);
        result = 31 * result + (this.exit != null ? this.exit.hashCode() : 0);
        result = 31 * result + (this.entrance != null ? this.entrance.hashCode() : 0);
        result = 31 * result + (this.entranceDirection != null ? this.entranceDirection.hashCode() : 0);
        result = 31 * result + this.endNoun.hashCode();
        return result;
    }

    public static enum Pointing {
        OUT,
        IN,
        HORIZONTALLY;

    }
}

