/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.states.position.updates;

import com.fabriziopolo.textcraft.events.notification.PlayerNotificationEvent;
import com.fabriziopolo.textcraft.nlg.NounPhrase;
import com.fabriziopolo.textcraft.nlg.NounPhraseWithArticle;
import com.fabriziopolo.textcraft.nlg.Preposition;
import com.fabriziopolo.textcraft.nlg.Prepositions;
import com.fabriziopolo.textcraft.player.Player;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.states.goability.GoHandler;
import com.fabriziopolo.textcraft.states.goability.GoableState;
import com.fabriziopolo.textcraft.states.position.PositionState;
import com.fabriziopolo.textcraft.states.position.PositionStateBuilder;
import com.fabriziopolo.textcraft.states.position.PositionUpdateRequest;
import com.fabriziopolo.textcraft.states.position.SpacialRelationship;
import com.fabriziopolo.textcraft.states.putreceiver.DefaultPutReceiver;
import com.fabriziopolo.textcraft.states.putreceiver.PutReceiver;
import com.fabriziopolo.textcraft.states.putreceiver.PutReceiverState;
import com.fabriziopolo.textcraft.states.structure.PassageFilter;
import com.fabriziopolo.textcraft.states.structure.StructureState;
import com.fabriziopolo.textcraft.states.takeable.DefaultTakeHandler;
import com.fabriziopolo.textcraft.states.takeable.TakeHandler;
import com.fabriziopolo.textcraft.states.takeable.TakeableState;
import java.util.List;

public class PlayerPutsNounRequest
implements PositionUpdateRequest {
    private final String verb;
    private final Player player;
    private final Noun nounToPut;
    private final Preposition preposition;
    private final Preposition reversePreposition;
    private final Noun spotToPutIt;
    private final Noun tool = null;

    public PlayerPutsNounRequest(Player player, Noun nounToPut, Preposition preposition, Noun spotToPutIt) {
        this("put", player, nounToPut, preposition, spotToPutIt);
    }

    public PlayerPutsNounRequest(String verb, Player player, Noun nounToPut, Preposition preposition, Noun spotToPutIt) {
        this.verb = verb;
        this.player = player;
        this.nounToPut = nounToPut;
        this.preposition = preposition;
        this.reversePreposition = Prepositions.guessInverseOf(preposition);
        this.spotToPutIt = spotToPutIt;
    }

    @Override
    public void apply(PositionStateBuilder partialState, Simulation simulation) {
        Frame frame = simulation.getCurrentFrame();
        TakeHandler takeHandler = TakeableState.get(frame).get(this.nounToPut);
        if (takeHandler == null) {
            takeHandler = new DefaultTakeHandler();
        }
        if (!takeHandler.isProducible(this.player, this.nounToPut, this.tool, frame)) {
            takeHandler.onNotProducible(this.player, this.nounToPut, this.tool, simulation, partialState);
            return;
        }
        SpacialRelationship spacialRelationship = SpacialRelationship.of(this.preposition);
        Noun entrance = PositionState.get(frame).getEntrance(this.spotToPutIt, spacialRelationship);
        if (entrance == null) {
            this.notifyPlayerCannotPut(simulation, this.nounToPut);
            return;
        }
        GoHandler goHandler = GoableState.get(frame).getGoHandler(this.spotToPutIt, spacialRelationship);
        NounPhrase theSpotPerception = NounPhraseWithArticle.the(this.spotToPutIt.getDefaultPerception(frame));
        Noun actualSpotToPutIt = goHandler == null ? this.spotToPutIt : goHandler.getPlaceToGo(this.spotToPutIt, spacialRelationship, frame);
        List<Noun> thingsToPut = takeHandler.willProduce(this.player, this.nounToPut, this.tool, simulation, partialState);
        PassageFilter passageFilter = StructureState.get(frame).getPassageFilter(entrance);
        thingsToPut.forEach(thing -> {
            if (passageFilter.onPassage(entrance, (Noun)thing, frame)) {
                NounPhrase theThingPerception = NounPhraseWithArticle.the(thing.getDefaultPerception(frame));
                PlayerNotificationEvent.post((Noun)this.player, simulation, "You " + this.verb + " " + theThingPerception + " " + this.preposition + " " + theSpotPerception + ".");
                PutReceiver putReceiver = this.getPutReceiver(actualSpotToPutIt, frame);
                putReceiver.handlePut(this.nounToPut, this.preposition, this.reversePreposition, this.player, partialState, simulation, actualSpotToPutIt);
            } else {
                this.notifyPlayerCannotPut(simulation, (Noun)thing);
            }
        });
    }

    private PutReceiver getPutReceiver(Noun spot, Frame frame) {
        PutReceiver handler = PutReceiverState.get(frame).getHandler(spot);
        if (handler != null) {
            return handler;
        }
        return new DefaultPutReceiver();
    }

    private void notifyPlayerCannotPut(Simulation simulation, Noun specificNoun) {
        Frame frame = simulation.getCurrentFrame();
        NounPhrase theThingPerception = NounPhraseWithArticle.the(specificNoun.getDefaultPerception(frame));
        NounPhrase theSpotPerception = NounPhraseWithArticle.the(this.spotToPutIt.getDefaultPerception(frame));
        PlayerNotificationEvent.post((Noun)this.player, simulation, "You cannot " + this.verb + " " + theThingPerception + " " + this.preposition + " " + theSpotPerception + ".");
    }
}

