/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.states.room;

import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.simulation.State;
import com.fabriziopolo.textcraft.simulation.StateChangeRequest;
import com.fabriziopolo.textcraft.states.room.RoomStateBuilder;
import com.fabriziopolo.textcraft.states.room.RoomStateUpdateRequest;
import com.fabriziopolo.textcraft.states.room.UpdateFloorRequest;
import com.fabriziopolo.textcraft.utils.Lockable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class RoomState
extends Lockable
implements State {
    protected final Map<Noun, Noun> mapNounsToFloors = new HashMap<Noun, Noun>();

    public static RoomState get(Frame frame) {
        return (RoomState)frame.states.get(RoomState.class);
    }

    public static RoomStateBuilder builder() {
        return new RoomStateBuilder();
    }

    public Noun getFloor(Noun roomNoun) {
        return this.mapNounsToFloors.get(roomNoun);
    }

    private List<RoomStateUpdateRequest> getRequests(Simulation simulation) {
        List<StateChangeRequest> reqs = simulation.getStateChangeRequests(RoomState.class);
        if (reqs == null) {
            return new ArrayList<RoomStateUpdateRequest>();
        }
        return reqs.stream().map(obj -> (RoomStateUpdateRequest)obj).collect(Collectors.toList());
    }

    @Override
    public State updateState(Simulation simulation) {
        RoomStateBuilder builder = new RoomStateBuilder(this);
        this.getRequests(simulation).forEach(req -> req.apply(builder));
        return builder.build();
    }

    @Override
    public String getDebugInfo(Noun noun, Frame frame) {
        return null;
    }

    public static void requestFloorUpdate(Noun noun, Noun floor, Simulation simulation) {
        simulation.requestStateChange(RoomState.class, new UpdateFloorRequest(noun, floor));
    }
}

