/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.states.scenery;

import com.fabriziopolo.textcraft.nlg.IndependentClause;
import com.fabriziopolo.textcraft.nlg.Nlg;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.perception.Perceiver;
import com.fabriziopolo.textcraft.simulation.perception.PerceptionChannel;
import com.fabriziopolo.textcraft.states.scenery.Scenery;

public final class SimpleScenery
implements Scenery {
    private final IndependentClause description;
    private final IndependentClause darkDescription;
    private final IndependentClause blindDescription;

    public SimpleScenery(IndependentClause description, IndependentClause darkDescription, IndependentClause blindDescription) {
        this.description = description;
        this.darkDescription = darkDescription;
        this.blindDescription = blindDescription;
    }

    public SimpleScenery(String description) {
        IndependentClause shortClause;
        this.description = shortClause = Nlg.literalClause(description);
        this.darkDescription = null;
        this.blindDescription = null;
    }

    public SimpleScenery(String description, String darkDescription) {
        IndependentClause shortClause = Nlg.literalClause(description);
        IndependentClause darkClause = Nlg.literalClause(darkDescription);
        this.description = shortClause;
        this.darkDescription = darkClause;
        this.blindDescription = null;
    }

    @Override
    public IndependentClause asPerceivedBy(Perceiver perceiver, Noun direction, Noun associatedNoun, PerceptionChannel channel, Frame frame) {
        if (channel == PerceptionChannel.DEFAULT) {
            return this.description;
        }
        if (channel == PerceptionChannel.DARK) {
            return this.darkDescription;
        }
        return this.blindDescription;
    }
}

