/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.states.weather.rain;

import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.states.position.AbstractPathAlgorithm;
import com.fabriziopolo.textcraft.states.position.PathSegment;
import com.fabriziopolo.textcraft.states.weather.WeatherState;
import com.fabriziopolo.textcraft.states.weather.rain.BlocksRainState;

public class RainTracePathAlgorithm
extends AbstractPathAlgorithm {
    private boolean blocked = false;

    @Override
    protected boolean before(Frame frame) {
        if (!WeatherState.isRainingOutside(frame)) {
            this.blocked = true;
            return false;
        }
        return true;
    }

    public boolean isRainingOn(Noun noun, Frame frame) {
        this.blocked = false;
        this.traversePathFromExterior(noun, frame);
        return !this.blocked;
    }

    @Override
    protected boolean onInternalNoun(Noun noun, PathSegment segment, Frame frame) {
        boolean nounBlocksRain = BlocksRainState.get(frame).blocksRain(noun);
        if (nounBlocksRain) {
            this.blocked = true;
            return false;
        }
        return true;
    }
}

