/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.text;

import com.fabriziopolo.textcraft.text.Text;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import org.codehaus.plexus.util.StringUtils;

public class TextTableBuilder {
    public static final BiFunction<String, Integer, String> LEFT_JUSTIFIED = TextTableBuilder::leftJustifiedFormatter;
    public static final BiFunction<String, Integer, String> RIGHT_JUSTIFIED = TextTableBuilder::rightJustifiedFormatter;
    public static final BiFunction<String, Integer, String> CENTER_JUSTIFIED = TextTableBuilder::centerJustifiedFormatter;
    private final List<List<String>> rows = new ArrayList<List<String>>();
    private final List<BiFunction<String, Integer, String>> columnFormatters = new ArrayList<BiFunction<String, Integer, String>>();

    public TextTableBuilder addRow() {
        this.rows.add(new ArrayList());
        return this;
    }

    public TextTableBuilder addCell(String contents) {
        if (this.rows.isEmpty()) {
            this.addRow();
        }
        this.rows.get(this.rows.size() - 1).add(contents);
        return this;
    }

    public TextTableBuilder addColumnFormatter(BiFunction<String, Integer, String> formatter) {
        this.columnFormatters.add(formatter);
        return this;
    }

    public String build() {
        int i;
        Integer rowLength = this.rows.get(0).size();
        ArrayList columnWidths = new ArrayList();
        ArrayList<String> rowStrings = new ArrayList<String>();
        for (i = 0; i < this.rows.size(); ++i) {
            rowStrings.add("");
        }
        for (i = 0; i < rowLength; ++i) {
            int idx = i;
            Integer width = this.rows.stream().map(row -> ((String)row.get(idx)).length()).max(Integer::compare).get();
            for (int rowIdx = 0; rowIdx < this.rows.size(); ++rowIdx) {
                rowStrings.set(rowIdx, (String)rowStrings.get(rowIdx) + this.columnFormatters.get(i).apply(this.rows.get(rowIdx).get(i), width));
            }
        }
        StringBuilder b = new StringBuilder();
        for (String row2 : rowStrings) {
            b.append(row2);
            b.append(Text.getLineSeparator());
        }
        return b.toString();
    }

    private static String leftJustifiedFormatter(String string, Integer width) {
        if (string.length() > width) {
            return string.substring(0, width);
        }
        return string + StringUtils.repeat(" ", width - string.length());
    }

    private static String rightJustifiedFormatter(String string, Integer width) {
        if (string.length() > width) {
            return string.substring(0, width);
        }
        return StringUtils.repeat(" ", width - string.length()) + string;
    }

    private static String centerJustifiedFormatter(String string, Integer width) {
        if (string.length() > width) {
            return string.substring(0, width);
        }
        int margin = width - string.length();
        int leftMargin = margin / 2;
        int rightMargin = margin - leftMargin;
        return StringUtils.repeat(" ", leftMargin) + string + StringUtils.repeat(" ", rightMargin);
    }

    public static BiFunction<String, Integer, String> fixedWidthFormatter(int fixedWidth, BiFunction<String, Integer, String> delegate) {
        return (cellText, width) -> (String)delegate.apply((String)cellText, fixedWidth);
    }
}

