/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.timecraft.game;

import com.fabriziopolo.textapp.TextAppController;
import com.fabriziopolo.textcraft.app.Game;
import com.fabriziopolo.textcraft.app.SinglePlayerGameState;
import com.fabriziopolo.textcraft.app.menu.SmartMenuLauncher;
import com.fabriziopolo.textcraft.commands.Command;
import com.fabriziopolo.textcraft.commands.DebugExamineCommand;
import com.fabriziopolo.textcraft.commands.DropCommand;
import com.fabriziopolo.textcraft.commands.EatCommand;
import com.fabriziopolo.textcraft.commands.ExamineCommand;
import com.fabriziopolo.textcraft.commands.GoCommand;
import com.fabriziopolo.textcraft.commands.GoPrepositionCommand;
import com.fabriziopolo.textcraft.commands.HelpCommand;
import com.fabriziopolo.textcraft.commands.InventoryCommand;
import com.fabriziopolo.textcraft.commands.LookCommand;
import com.fabriziopolo.textcraft.commands.LookDirectionCommand;
import com.fabriziopolo.textcraft.commands.PutCommand;
import com.fabriziopolo.textcraft.commands.RemoveCommand;
import com.fabriziopolo.textcraft.commands.SleepCommand;
import com.fabriziopolo.textcraft.commands.StatusCommand;
import com.fabriziopolo.textcraft.commands.TakeCommand;
import com.fabriziopolo.textcraft.commands.UnwieldCommand;
import com.fabriziopolo.textcraft.commands.UseCommand;
import com.fabriziopolo.textcraft.commands.WaitCommand;
import com.fabriziopolo.textcraft.commands.WearCommand;
import com.fabriziopolo.textcraft.commands.WieldCommand;
import com.fabriziopolo.textcraft.player.Player;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.SinglePlayerSimulation;
import com.fabriziopolo.textcraft.simulation.State;
import com.fabriziopolo.textcraft.simulation.UpdateParameters;
import com.fabriziopolo.textcraft.states.capability.ResourceState;
import com.fabriziopolo.textcraft.states.capability.ToolState;
import com.fabriziopolo.textcraft.states.characterbio.awake.AwakeState;
import com.fabriziopolo.textcraft.states.characterbio.energy.EnergyState;
import com.fabriziopolo.textcraft.states.characterbio.health.HealthState;
import com.fabriziopolo.textcraft.states.characterbio.hunger.HungerState;
import com.fabriziopolo.textcraft.states.characterbio.hydration.HydrationState;
import com.fabriziopolo.textcraft.states.characterbio.oxygen.OxygenState;
import com.fabriziopolo.textcraft.states.constants.Directions;
import com.fabriziopolo.textcraft.states.coordinate.CoordinateState;
import com.fabriziopolo.textcraft.states.description.DescriptionState;
import com.fabriziopolo.textcraft.states.description.ProminenceState;
import com.fabriziopolo.textcraft.states.edibility.EdibilityState;
import com.fabriziopolo.textcraft.states.encumbrance.EncumbranceState;
import com.fabriziopolo.textcraft.states.goability.GoableState;
import com.fabriziopolo.textcraft.states.inventory.InventoryState;
import com.fabriziopolo.textcraft.states.light.LightState;
import com.fabriziopolo.textcraft.states.notification.NotificationState;
import com.fabriziopolo.textcraft.states.perception.PerceptionFilterState;
import com.fabriziopolo.textcraft.states.position.PositionState;
import com.fabriziopolo.textcraft.states.putreceiver.PutReceiverState;
import com.fabriziopolo.textcraft.states.room.RoomState;
import com.fabriziopolo.textcraft.states.scenery.SceneryState;
import com.fabriziopolo.textcraft.states.shade.ShadeState;
import com.fabriziopolo.textcraft.states.singleplayer.EndGameState;
import com.fabriziopolo.textcraft.states.singleplayer.WaitState;
import com.fabriziopolo.textcraft.states.structure.StructureState;
import com.fabriziopolo.textcraft.states.sun.SunState;
import com.fabriziopolo.textcraft.states.takeable.TakeableState;
import com.fabriziopolo.textcraft.states.temperature.TemperatureEffectState;
import com.fabriziopolo.textcraft.states.temperature.TemperatureFilterState;
import com.fabriziopolo.textcraft.states.temperature.TemperatureState;
import com.fabriziopolo.textcraft.states.time.TimeState;
import com.fabriziopolo.textcraft.states.updatable.UpdateableState;
import com.fabriziopolo.textcraft.states.useable.UseableState;
import com.fabriziopolo.textcraft.states.water.SubmersionEffect;
import com.fabriziopolo.textcraft.states.water.SubmersionEffectState;
import com.fabriziopolo.textcraft.states.water.WaterState;
import com.fabriziopolo.textcraft.states.wearabililty.WearabilityState;
import com.fabriziopolo.textcraft.states.weather.WeatherState;
import com.fabriziopolo.textcraft.states.weather.rain.BlocksRainState;
import com.fabriziopolo.textcraft.states.weather.rain.RainEffectState;
import com.fabriziopolo.textcraft.text.InputParser;
import com.fabriziopolo.timecraft.world.map.tutorial.TutorialWorldBuilder;
import com.fabriziopolo.timecraft.world.weather.NeutralWeatherProvider;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;

public class TutorialGame
extends Game {
    private static final double DEFAULT_DT = 1.0;
    private static final double DEFAULT_TIMESCALE = 96.0;
    public static final UpdateParameters DEFAULT_UPDATE_PARAMETERS = new UpdateParameters(1.0, 96.0);

    public TutorialGame() {
        super("TextCraft", "Tutorial", "0.1");
    }

    private String getTitleArt() {
        return "\n\n\n\n            ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n\n\n\n";
    }

    @Override
    public void start(TextAppController controller) {
        controller.getTxt().println(this.getTitleArt());
        SmartMenuLauncher.launch(controller, new CreateInitialTutorialGameState(this));
    }

    @Override
    public SinglePlayerGameState createInitialGameState() {
        return new SinglePlayerGameState(new InputParser(), this.createEmptySimulation());
    }

    private InputParser createInputParser() {
        InputParser parser = new InputParser();
        ArrayList<Command> commands = new ArrayList<Command>();
        commands.add(new GoCommand());
        commands.add(new LookCommand());
        commands.add(new LookDirectionCommand());
        commands.add(new ExamineCommand());
        commands.add(new InventoryCommand());
        commands.add(new TakeCommand());
        commands.add(new DropCommand());
        commands.add(new StatusCommand());
        commands.add(new EatCommand());
        commands.add(new WieldCommand());
        commands.add(new UnwieldCommand());
        commands.add(new SleepCommand());
        commands.add(new WaitCommand());
        commands.add(new GoPrepositionCommand());
        commands.add(new WearCommand());
        commands.add(new RemoveCommand());
        commands.add(new PutCommand());
        commands.add(new UseCommand());
        this.addDebugCommands(commands);
        commands.add(new HelpCommand(commands));
        parser.addCommands(commands);
        return parser;
    }

    private void addDebugCommands(List<Command> commands) {
        commands.add(new DebugExamineCommand());
    }

    private SinglePlayerSimulation createEmptySimulation() {
        SinglePlayerSimulation simulation = new SinglePlayerSimulation(this.createSeedFrame(), new Player(), DEFAULT_UPDATE_PARAMETERS, new Random(0L));
        return simulation;
    }

    private SinglePlayerSimulation createTutorialGameSimulation() {
        SinglePlayerSimulation simulation = this.createEmptySimulation();
        new TutorialWorldBuilder(simulation).buildWorld();
        simulation.update();
        return simulation;
    }

    private Frame createSeedFrame() {
        HashMap<Object, State> states = new HashMap<Object, State>();
        states.put(TimeState.class, new TimeState(Instant.parse("2016-09-13T06:00:00.00Z"), 0.0));
        states.put(PositionState.class, PositionState.builder().build());
        states.put(InventoryState.class, InventoryState.builder().build());
        states.put(RoomState.class, RoomState.builder().build());
        states.put(HungerState.class, HungerState.builder().build());
        states.put(HydrationState.class, HydrationState.builder().build());
        states.put(HealthState.class, HealthState.builder().build());
        states.put(EnergyState.class, EnergyState.builder().build());
        states.put(AwakeState.class, AwakeState.builder().build());
        states.put(SunState.class, SunState.builder().build());
        states.put(EdibilityState.class, EdibilityState.builder().build());
        states.put(LightState.class, LightState.builder().build());
        states.put(StructureState.class, StructureState.builder().build());
        states.put(DescriptionState.class, DescriptionState.builder().build());
        states.put(NotificationState.class, NotificationState.builder().build());
        states.put(WaterState.class, WaterState.builder().build());
        states.put(TakeableState.class, TakeableState.builder().build());
        states.put(ToolState.class, ToolState.builder().build());
        states.put(ResourceState.class, ResourceState.builder().build());
        states.put(GoableState.class, GoableState.builder().build());
        states.put(WeatherState.class, new WeatherState(new NeutralWeatherProvider()));
        states.put(RainEffectState.class, RainEffectState.builder().build());
        states.put(ShadeState.class, ShadeState.builder().build());
        states.put(SubmersionEffect.class, new SubmersionEffectState());
        states.put(OxygenState.class, new OxygenState());
        states.put(BlocksRainState.class, new BlocksRainState());
        states.put(WearabilityState.class, new WearabilityState());
        states.put(CoordinateState.class, new CoordinateState());
        states.put(PutReceiverState.class, new PutReceiverState());
        states.put(UpdateableState.class, new UpdateableState());
        states.put(PerceptionFilterState.class, new PerceptionFilterState());
        states.put(TemperatureState.class, new TemperatureState());
        states.put(TemperatureEffectState.class, new TemperatureEffectState());
        states.put(ProminenceState.class, new ProminenceState());
        states.put(WaitState.class, new WaitState());
        states.put(SceneryState.class, new SceneryState());
        states.put(UseableState.class, new UseableState());
        states.put(TemperatureFilterState.class, new TemperatureFilterState());
        states.put(EncumbranceState.class, new EncumbranceState());
        states.put(EndGameState.class, new EndGameState());
        states.put(Directions.class, new Directions());
        return Frame.builder().setStates(states).setUpdateParamters(DEFAULT_UPDATE_PARAMETERS).build();
    }

    private static final class CreateInitialTutorialGameState
    implements Supplier<SinglePlayerGameState>,
    Serializable {
        private final TutorialGame game;

        private CreateInitialTutorialGameState(TutorialGame game) {
            this.game = game;
        }

        @Override
        public SinglePlayerGameState get() {
            return new SinglePlayerGameState(this.game.createInputParser(), this.game.createTutorialGameSimulation());
        }
    }
}

