/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.timecraft.world.map.rendering;

import com.fabriziopolo.textcraft.player.Player;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.SinglePlayerSimulation;
import com.fabriziopolo.textcraft.states.coordinate.CoordinateState;
import com.fabriziopolo.textcraft.states.coordinate.Coordinates;
import com.fabriziopolo.textcraft.worldbuilder.WorldBuilder;
import com.fabriziopolo.timecraft.world.dsl.Dsl;
import com.fabriziopolo.timecraft.world.map.rendering.MapPopulator;

public class RectangularWorldMapBuilder
extends WorldBuilder {
    private final Dsl dsl;
    private final Player player;
    private final MapPopulator mapPopulator;
    private final int eastWestLength;
    private final int northSouthLength;
    private final int startX;
    private final int startY;
    private final Noun[][] map;

    public RectangularWorldMapBuilder(SinglePlayerSimulation simulation, MapPopulator mapPopulator, int eastWestLength, int northSouthLength, int startX, int startY) {
        super(simulation);
        this.dsl = new Dsl(simulation);
        this.player = simulation.player;
        this.mapPopulator = mapPopulator;
        this.eastWestLength = eastWestLength;
        this.northSouthLength = northSouthLength;
        this.startX = startX;
        this.startY = startY;
        this.map = new Noun[this.eastWestLength][this.northSouthLength];
    }

    public void buildWorld() {
        this.createRooms();
        this.simulation.update();
        this.createObjects();
        this.simulation.update();
        this.createExitsAndEntrances();
        this.simulation.update();
        this.createScenery();
        this.simulation.update();
    }

    public void finish() {
        this.mapPopulator.finish();
        this.simulation.update();
    }

    private void createRooms() {
        for (int x = 0; x < this.eastWestLength; ++x) {
            for (int y = 0; y < this.northSouthLength; ++y) {
                this.map[x][y] = this.mapPopulator.createNewRoomAt(x, y);
                CoordinateState.reqeustPut(this.map[x][y], new Coordinates(x, y), this.simulation);
            }
        }
    }

    private void createObjects() {
        for (int x = 0; x < this.eastWestLength; ++x) {
            for (int y = 0; y < this.northSouthLength; ++y) {
                this.mapPopulator.putObjectsInRoom(this.map[x][y], x, y);
            }
        }
    }

    private void createExitsAndEntrances() {
        for (int x = 0; x < this.eastWestLength; ++x) {
            for (int y = 0; y < this.northSouthLength; ++y) {
                this.mapPopulator.createExitsAndEntrancesAt(x, y, this.map);
            }
        }
    }

    private void createScenery() {
        for (int x = 0; x < this.eastWestLength; ++x) {
            for (int y = 0; y < this.northSouthLength; ++y) {
                this.mapPopulator.addScenery(this.map[x][y], x, y);
            }
        }
    }

    public Noun getStartRoom() {
        return this.map[this.startX][this.startY];
    }
}

