/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.timecraft.world.map.timelapse;

import com.fabriziopolo.textcraft.player.Player;
import com.fabriziopolo.textcraft.simulation.SinglePlayerSimulation;
import com.fabriziopolo.textcraft.worldbuilder.WorldBuilder;
import com.fabriziopolo.timecraft.world.map.rendering.RectangularWorldMapBuilder;
import com.fabriziopolo.timecraft.world.map.timelapse.TimeLapseMapPopulator;
import com.fabriziopolo.timecraft.world.map.timelapse.TimeLapsePlayerBuilder;

public class TimeLapseWorldBuilder
extends WorldBuilder {
    private final Player player;
    private final int eastWestLength = 20;
    private final int northSouthLength = 20;
    private final int startX;
    private final int startY;
    private final TimeLapseMapPopulator mapPopulator;
    private final RectangularWorldMapBuilder rectangularWorldMapBuilder;

    public TimeLapseWorldBuilder(SinglePlayerSimulation simulation) {
        super(simulation);
        this.player = simulation.player;
        this.mapPopulator = new TimeLapseMapPopulator(simulation, this.player, 20, 20);
        this.startX = this.mapPopulator.getxStart();
        this.startY = this.mapPopulator.getyStart();
        this.rectangularWorldMapBuilder = new RectangularWorldMapBuilder(simulation, this.mapPopulator, 20, 20, this.startX, this.startY);
    }

    public void buildWorld() {
        this.rectangularWorldMapBuilder.buildWorld();
        this.createPlayer();
        this.simulation.update();
        this.simulation.update();
        this.simulation.update();
        this.simulation.update();
        this.rectangularWorldMapBuilder.finish();
    }

    private void createPlayer() {
        new TimeLapsePlayerBuilder(this.simulation).buildPlayer(this.player, this.rectangularWorldMapBuilder.getStartRoom());
    }
}

