/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.timecraft.world.weather;

import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.states.temperature.FlexibleHeatUnit;
import com.fabriziopolo.textcraft.states.time.TimeState;
import com.fabriziopolo.textcraft.states.weather.WeatherProvider;

public class AlphaIslandWeatherProvider
implements WeatherProvider {
    private final double AIR_TEMP_DAY_NIGHT_VARIATION_SCALE = 1.5;

    @Override
    public boolean isRainingAtHours(double timeHours) {
        int day = (int)timeHours / 24;
        int hour = (int)timeHours % 24;
        switch (day) {
            case 0: {
                return 10 <= hour && hour < 14;
            }
            case 2: {
                return 12 < hour && hour < 16;
            }
            case 5: {
                return 18 <= hour;
            }
            case 6: {
                return hour < 6;
            }
        }
        return false;
    }

    @Override
    public FlexibleHeatUnit getAirTemperatureAt(Noun noun, Frame frame) {
        double timeHours = TimeState.getGameTimeElapsedHoursSinceDay0(frame);
        FlexibleHeatUnit baseTemp = this.getBaseTemperature(timeHours);
        double x = (timeHours - 13.0) / 24.0 * 2.0 * Math.PI;
        double airTempDelta = Math.cos(x) * 1.5;
        return baseTemp.plus(FlexibleHeatUnit.create(airTempDelta));
    }

    private FlexibleHeatUnit getBaseTemperature(double timeHours) {
        int day = (int)timeHours / 24;
        int hour = (int)timeHours % 24;
        FlexibleHeatUnit VERY_COLD_TEMP = FlexibleHeatUnit.create(-4.5);
        FlexibleHeatUnit COLD_TEMP = FlexibleHeatUnit.create(-3.1);
        FlexibleHeatUnit COOL_TEMP = FlexibleHeatUnit.create(-2.2);
        FlexibleHeatUnit NEUTRAL_TEMP = FlexibleHeatUnit.create(-1.0);
        FlexibleHeatUnit WARM_TEMP = FlexibleHeatUnit.create(0.0);
        FlexibleHeatUnit HOT_TEMP = FlexibleHeatUnit.create(1.0);
        FlexibleHeatUnit VERY_HOT_TEMP = FlexibleHeatUnit.create(2.0);
        switch (day) {
            case 0: {
                return WARM_TEMP;
            }
            case 1: {
                return HOT_TEMP;
            }
            case 2: {
                return VERY_HOT_TEMP;
            }
            case 3: {
                if (hour < 12) {
                    return NEUTRAL_TEMP;
                }
                return COOL_TEMP;
            }
            case 4: {
                return COLD_TEMP;
            }
            case 5: {
                return VERY_COLD_TEMP;
            }
            case 6: {
                if (hour < 5) {
                    return VERY_COLD_TEMP;
                }
                if (hour < 6) {
                    return COLD_TEMP;
                }
                if (hour < 7) {
                    return COOL_TEMP;
                }
                return NEUTRAL_TEMP;
            }
            case 7: {
                break;
            }
            case 8: {
                break;
            }
        }
        return NEUTRAL_TEMP;
    }
}

