/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lexAccess.Tools.GuiTool.Gui;

import gov.nih.nlm.nls.lexAccess.Tools.GuiTool.Gui.ByBasePanel;
import gov.nih.nlm.nls.lexAccess.Tools.GuiTool.Gui.ByCategoryPanel;
import gov.nih.nlm.nls.lexAccess.Tools.GuiTool.Gui.ByTermEuiPanel;
import gov.nih.nlm.nls.lexAccess.Tools.GuiTool.Gui.GlobalOptionDialog;
import gov.nih.nlm.nls.lexAccess.Tools.GuiTool.Gui.InputSourceDialog;
import gov.nih.nlm.nls.lexAccess.Tools.GuiTool.Gui.LaMenuBar;
import gov.nih.nlm.nls.lexAccess.Tools.GuiTool.Gui.MainPanel;
import gov.nih.nlm.nls.lexAccess.Tools.GuiTool.Gui.OutputOptionDialog;
import gov.nih.nlm.nls.lexAccess.Tools.GuiTool.Gui.OutputSourceDialog;
import gov.nih.nlm.nls.lexAccess.Tools.GuiTool.GuiControl.KeysControl;
import gov.nih.nlm.nls.lexAccess.Tools.GuiTool.GuiLib.DocHtmlBrowser;
import gov.nih.nlm.nls.lexAccess.Tools.GuiTool.Model.LaObj;
import gov.nih.nlm.nls.lexAccess.Tools.GuiTool.Operations.GuiOperations;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Toolkit;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class LaFrame
extends JFrame {
    private static final long serialVersionUID = 5L;
    private static final String LA_VERSION = "LexAccess, 2011";
    private LaObj laObj_ = new LaObj();
    private boolean bold_ = false;
    private boolean italic_ = false;
    private String style_ = "Dialog";
    private int size_ = 12;
    private Font font_ = null;
    private Font guiFont_ = null;
    private LaFrame laFrame_ = null;
    private LaMenuBar laMenuBar_ = null;
    private DocHtmlBrowser helpDoc_ = null;
    private JPanel mainPanel_;
    private JDialog inputSourceDialog_;
    private JDialog outputSourceDialog_;
    private JDialog globalOptionDialog_;
    private JDialog outputOptionDialog_;

    public LaFrame() {
        new MainPanel(this);
        this.mainPanel_ = MainPanel.GetMainPanel(0);
        this.inputSourceDialog_ = null;
        this.outputSourceDialog_ = null;
        this.globalOptionDialog_ = null;
        this.outputOptionDialog_ = null;
        this.laFrame_ = this;
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension d = tk.getScreenSize();
        int screenHeight = d.height;
        int screenWidth = d.width;
        this.setDefaultCloseOperation(2);
        this.setTitle("LexAccess GUI Tool");
        this.setSize(600, 700);
        this.setLocation(5, 10);
        this.setResizable(true);
        Image img = tk.getImage(this.laObj_.GetConfigObj().GetLaDir() + "/data/image/lexAccessLogo.jpg");
        this.setIconImage(img);
        this.laMenuBar_ = new LaMenuBar(this);
        this.setJMenuBar(this.laMenuBar_);
        this.getContentPane().add(this.mainPanel_);
        this.addKeyListener(new KeysControl(this.laFrame_));
        new InputSourceDialog(this);
        this.inputSourceDialog_ = InputSourceDialog.GetDialog(this);
        new OutputSourceDialog(this);
        this.outputSourceDialog_ = OutputSourceDialog.GetDialog(this);
        new GlobalOptionDialog(this);
        this.globalOptionDialog_ = GlobalOptionDialog.GetDialog(this);
        new OutputOptionDialog(this);
        this.outputOptionDialog_ = OutputOptionDialog.GetDialog(this);
    }

    public void SetMainPanel(int searchMode) {
        this.mainPanel_ = MainPanel.GetMainPanel(searchMode);
        ByTermEuiPanel.UpdateInputPanel(this.laObj_.GetInSource());
        ByBasePanel.UpdateInputPanel(this.laObj_.GetInSource());
        ByCategoryPanel.UpdateInputPanel(this.laObj_.GetInSource());
    }

    public JDialog GetInputSourceDialog() {
        return this.inputSourceDialog_;
    }

    public JDialog GetOutputSourceDialog() {
        return this.outputSourceDialog_;
    }

    public JDialog GetGlobalOptionDialog() {
        return this.globalOptionDialog_;
    }

    public JDialog GetOutputOptionDialog() {
        return this.outputOptionDialog_;
    }

    public DocHtmlBrowser GetHelpDoc() {
        return this.helpDoc_;
    }

    public void SetHelpDoc(DocHtmlBrowser helpDoc) {
        this.helpDoc_ = helpDoc;
    }

    public void SetStyle(String style) {
        this.style_ = style;
    }

    public void ToggleBold() {
        this.bold_ = !this.bold_;
    }

    public void ToggleItalic() {
        this.italic_ = !this.italic_;
    }

    public void SetSize(int size) {
        this.size_ = size;
    }

    public void SetDefaultFont() {
        this.laMenuBar_.SetDefaultFontMenu();
        this.style_ = "Dialog";
        this.bold_ = false;
        this.italic_ = false;
        this.size_ = 12;
    }

    public void UpdateFont() {
        this.font_ = new Font(this.style_, (this.bold_ ? 1 : 0) + (this.italic_ ? 2 : 0), this.size_);
        this.guiFont_ = new Font(this.style_, 1 + (this.italic_ ? 2 : 0), this.size_);
        GuiOperations.UpdateFont(this.font_, this.guiFont_, this.laFrame_);
        LaMenuBar.SetFont(this.font_, this.guiFont_);
        MainPanel.SetFont(this.font_, this.guiFont_);
        InputSourceDialog.SetFont(this.font_, this.guiFont_);
        GlobalOptionDialog.SetFont(this.font_, this.guiFont_);
        OutputOptionDialog.SetFont(this.font_, this.guiFont_);
        if (this.helpDoc_ != null) {
            this.helpDoc_.SetFont(this.font_, this.guiFont_);
        }
    }

    public Font GetFont() {
        return this.font_;
    }

    public Font GetGuiFont() {
        return this.guiFont_;
    }

    public void Dispose() {
        if (this.helpDoc_ != null) {
            this.helpDoc_.dispose();
        }
        this.inputSourceDialog_.dispose();
        this.outputSourceDialog_.dispose();
        this.globalOptionDialog_.dispose();
        this.outputOptionDialog_.dispose();
        this.laFrame_.dispose();
    }

    public LaObj GetLaObj() {
        return this.laObj_;
    }
}

