/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lexAccess.Tools.GuiTool.Operations;

import gov.nih.nlm.nls.lexAccess.Tools.GuiTool.Gui.ByBasePanel;
import gov.nih.nlm.nls.lexAccess.Tools.GuiTool.Gui.ByCategoryPanel;
import gov.nih.nlm.nls.lexAccess.Tools.GuiTool.Gui.ByTermEuiPanel;
import gov.nih.nlm.nls.lexAccess.Tools.GuiTool.Gui.LaFrame;
import gov.nih.nlm.nls.lexAccess.Tools.GuiTool.Model.LaObj;
import gov.nih.nlm.nls.lexAccess.Tools.GuiTool.Operations.FileIoOperations;
import java.io.File;
import java.util.GregorianCalendar;
import java.util.Vector;

public class ByTermEuiOperations {
    private ByTermEuiOperations() {
    }

    public static void SearchOperation(LaObj laObj) {
        String inStr = new String();
        String outStr = new String();
        if (laObj.GetInSource() == 0) {
            inStr = ByTermEuiPanel.GetTermEuiField().getText();
            outStr = laObj.GetLexAccessResultsByTerm(inStr);
        } else {
            Vector<String> inStrs = FileIoOperations.ReadFromFile(laObj.GetInFile());
            for (int i = 0; i < inStrs.size(); ++i) {
                String tempInStr = inStrs.elementAt(i);
                outStr = outStr + laObj.GetLexAccessResultsByTerm(tempInStr);
            }
        }
        if (laObj.GetOutSource() == 0) {
            ByTermEuiPanel.GetLaOutputs().setText(outStr);
            ByTermEuiPanel.GetLaOutputs().setCaretPosition(0);
        } else {
            String outPath = new String();
            File outFile = laObj.GetOutFile();
            try {
                outPath = outFile.getCanonicalPath();
            }
            catch (Exception e) {
                // empty catch block
            }
            boolean append = laObj.GetAppendToOutFile();
            String msgStr = "--- The results are saved to the following file ---\n";
            if (append) {
                msgStr = "--- The results are appended to the following file ---\n";
            }
            GregorianCalendar cal = new GregorianCalendar();
            msgStr = msgStr + outPath + "\n" + "@" + cal.getTime().toString();
            ByTermEuiPanel.GetLaOutputs().setText(msgStr);
            ByTermEuiPanel.GetLaOutputs().setCaretPosition(0);
            FileIoOperations.WriteToFile(outFile, outStr, append);
        }
    }

    public static void ClearOperation() {
        ByTermEuiPanel.GetTermEuiField().setText(new String());
    }

    public static void ResetOperation(LaFrame owner) {
        owner.GetLaObj().ResetAllOptions();
        ByTermEuiPanel.GetTermEuiField().setText(new String());
        ByTermEuiPanel.GetLaOutputs().setText("-- All Options of LexAccess Tool are reset to default values.");
        ByTermEuiPanel.UpdateInputPanel(owner.GetLaObj().GetInSource());
        ByBasePanel.UpdateInputPanel(owner.GetLaObj().GetInSource());
        ByCategoryPanel.UpdateInputPanel(owner.GetLaObj().GetInSource());
    }
}

