/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lexCheck.Cat.Verb;

import gov.nih.nlm.nls.lexCheck.Compl.CheckEdComp;
import gov.nih.nlm.nls.lexCheck.Compl.CheckFinComp;
import gov.nih.nlm.nls.lexCheck.Compl.CheckInfComp;
import gov.nih.nlm.nls.lexCheck.Compl.CheckIngComp;
import gov.nih.nlm.nls.lexCheck.Compl.CheckParticle;
import gov.nih.nlm.nls.lexCheck.Compl.CheckPphr;
import gov.nih.nlm.nls.lexCheck.Lib.CheckFormat;
import java.util.HashSet;

public class CheckFormatVerbLink
implements CheckFormat {
    private static final int LEGAL_FILLER_NUM = 3;
    private static HashSet<String> filler_ = new HashSet(3);

    @Override
    public boolean IsLegalFormat(String inCode) {
        boolean flag = false;
        int partIndex = inCode.indexOf(";part(");
        String filler = null;
        String particle = null;
        if (partIndex != -1) {
            filler = inCode.substring(0, partIndex);
            particle = inCode.substring(partIndex);
        } else {
            filler = inCode;
        }
        flag = particle != null ? this.CheckLinkFiller(filler) && CheckParticle.IsLegal(particle) : this.CheckLinkFiller(filler);
        return flag;
    }

    private boolean CheckLinkFiller(String filler) {
        boolean flag = false;
        if (filler_.contains(filler)) {
            flag = true;
        } else if (filler.startsWith("edcomp:")) {
            flag = CheckEdComp.IsLegal(filler);
        } else if (filler.startsWith("fincomp(")) {
            flag = CheckFinComp.IsLegal(filler);
        } else if (filler.startsWith("infcomp:")) {
            flag = CheckInfComp.IsLegal(filler);
        } else if (filler.startsWith("ingcomp:")) {
            flag = CheckIngComp.IsLegal(filler);
        } else if (filler.startsWith("pphr(")) {
            flag = CheckPphr.IsLegal(filler);
        }
        return flag;
    }

    static {
        filler_.add("adj");
        filler_.add("advbl");
        filler_.add("np");
    }
}

