/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lexCheck.Cat.Verb;

import gov.nih.nlm.nls.lexCheck.Compl.CheckAsComp;
import gov.nih.nlm.nls.lexCheck.Compl.CheckBinfComp;
import gov.nih.nlm.nls.lexCheck.Compl.CheckFinComp;
import gov.nih.nlm.nls.lexCheck.Compl.CheckInfComp;
import gov.nih.nlm.nls.lexCheck.Compl.CheckIngComp;
import gov.nih.nlm.nls.lexCheck.Compl.CheckNpComp;
import gov.nih.nlm.nls.lexCheck.Compl.CheckParticle;
import gov.nih.nlm.nls.lexCheck.Compl.CheckPphr;
import gov.nih.nlm.nls.lexCheck.Compl.CheckWhinfComp;
import gov.nih.nlm.nls.lexCheck.Lib.CheckFormat;
import java.util.HashSet;

public class CheckFormatVerbTran
implements CheckFormat {
    private static final int LEGAL_FILLER_NUM = 2;
    private static HashSet<String> filler_ = new HashSet(2);

    @Override
    public boolean IsLegalFormat(String inCode) {
        boolean flag = false;
        int partIndex = inCode.indexOf(";part(");
        int passiveIndex = inCode.indexOf(";nopass");
        int noPrtmvtIndex = inCode.indexOf(";noprtmvt");
        String filler = null;
        String particle = null;
        boolean passive = false;
        boolean noPrtmvt = false;
        if (partIndex != -1) {
            filler = inCode.substring(0, partIndex);
            particle = passiveIndex != -1 ? inCode.substring(partIndex, passiveIndex) : (noPrtmvtIndex != -1 ? inCode.substring(partIndex, noPrtmvtIndex) : inCode.substring(partIndex));
        } else {
            filler = passiveIndex != -1 ? inCode.substring(0, passiveIndex) : (noPrtmvtIndex != -1 ? inCode.substring(0, noPrtmvtIndex) : inCode);
        }
        flag = particle != null ? this.CheckTranFiller(filler) && CheckParticle.IsLegal(particle) : this.CheckTranFiller(filler);
        return flag;
    }

    private boolean CheckTranFiller(String filler) {
        boolean flag = false;
        flag = filler_.contains(filler) ? true : (filler.startsWith("ascomp:") ? CheckAsComp.IsLegal(filler) : (filler.startsWith("binfcomp:") ? CheckBinfComp.IsLegal(filler) : (filler.startsWith("fincomp(") ? CheckFinComp.IsLegal(filler) : (filler.startsWith("infcomp:") ? CheckInfComp.IsLegal(filler) : (filler.startsWith("ingcomp:") ? CheckIngComp.IsLegal(filler) : (filler.startsWith("np|") ? CheckNpComp.IsLegal(filler) : (filler.startsWith("pphr(") ? CheckPphr.IsLegal(filler) : (filler.startsWith("whinfcomp:") ? CheckWhinfComp.IsLegal(filler) : false))))))));
        return flag;
    }

    static {
        filler_.add("np");
        filler_.add("whfincomp");
    }
}

