/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lexCheck.CkLib;

import gov.nih.nlm.nls.lexCheck.CkLib.CheckObject;
import gov.nih.nlm.nls.lexCheck.CkLib.LineCheck;
import gov.nih.nlm.nls.lexCheck.Lib.CheckSt;
import gov.nih.nlm.nls.lexCheck.Lib.ErrMsg;
import gov.nih.nlm.nls.lexCheck.Lib.LexRecord;
import gov.nih.nlm.nls.lexCheck.Lib.LineObject;
import gov.nih.nlm.nls.lexCheck.Lib.TokenObject;
import gov.nih.nlm.nls.lexCheck.Lib.UpdateLex;

public class CheckCode {
    public static final int FQ_ONE = 1;
    public static final int FQ_ZERO_ONE = 2;
    public static final int FQ_ZERO_MANY = 3;
    public static final int FQ_ONE_MANY = 4;
    public static final int FQ_ONE_WHOLE_LINE = 5;
    public static final int FQ_ZERO_ONE_WHOLE_LINE = 6;

    public static boolean Check(LineObject lineObject, boolean printFlag, CheckSt st, LexRecord lexObj, CheckObject checkObject, UpdateLex updateLex, int frequency, boolean checkLength) {
        boolean flag = false;
        switch (frequency) {
            case 1: {
                flag = CheckCode.CheckOne(lineObject, printFlag, st, lexObj, checkObject, updateLex, checkLength, true);
                break;
            }
            case 2: {
                flag = CheckCode.CheckZeroOne(lineObject, printFlag, st, lexObj, checkObject, updateLex, checkLength);
                break;
            }
            case 3: {
                flag = CheckCode.CheckZeroMany(lineObject, printFlag, st, lexObj, checkObject, updateLex, checkLength);
                break;
            }
            case 4: {
                flag = CheckCode.CheckOneMany(lineObject, printFlag, st, lexObj, checkObject, updateLex, checkLength);
                break;
            }
            case 5: {
                flag = CheckCode.CheckOneWholeLine(lineObject, printFlag, st, lexObj, checkObject, updateLex);
                break;
            }
            case 6: {
                flag = CheckCode.CheckZeroOneWholeLine(lineObject, printFlag, st, lexObj, checkObject, updateLex);
            }
        }
        return flag;
    }

    private static boolean CheckOne(LineObject lineObject, boolean printFlag, CheckSt st, LexRecord lexObj, CheckObject checkObject, UpdateLex updateLex, boolean checkLength, boolean updateState) {
        TokenObject tokenObject;
        lineObject.SetGoToNext(true);
        boolean flag = LineCheck.CheckStartStr(lineObject, printFlag, checkObject);
        st.UpdateLastState();
        if (flag && (flag = LineCheck.CheckSlotFiller(lineObject, printFlag, checkObject, tokenObject = new TokenObject(), checkLength))) {
            if (updateState) {
                st.UpdateCurState(checkObject.GetNextState());
            }
            if (updateLex != null) {
                updateLex.Update(lexObj, tokenObject.GetToken());
            }
        }
        return flag;
    }

    private static boolean CheckZeroOne(LineObject lineObject, boolean printFlag, CheckSt st, LexRecord lexObj, CheckObject checkObject, UpdateLex updateLex, boolean checkLength) {
        String line = lineObject.GetLine();
        boolean flag = checkObject.IsNextStartStr(line);
        if (flag) {
            st.UpdateCurState(checkObject.GetNextState());
            lineObject.SetGoToNext(false);
            return flag;
        }
        if (st.GetCurState() != st.GetLastState()) {
            st.UpdateLastState();
            flag = CheckCode.CheckOne(lineObject, printFlag, st, lexObj, checkObject, updateLex, checkLength, false);
        } else {
            ErrMsg.PrintErrMsg(printFlag, 82, lineObject, line, 0, line.length(), checkObject.IsTab());
            st.UpdateLastState();
            flag = false;
        }
        return flag;
    }

    private static boolean CheckZeroMany(LineObject lineObject, boolean printFlag, CheckSt st, LexRecord lexObj, CheckObject checkObject, UpdateLex updateLex, boolean checkLength) {
        TokenObject tokenObject;
        lineObject.SetGoToNext(true);
        st.UpdateLastState();
        boolean flag = checkObject.IsNextStartStr(lineObject.GetLine());
        if (flag) {
            st.UpdateCurState(checkObject.GetNextState());
            lineObject.SetGoToNext(false);
            return flag;
        }
        flag = LineCheck.CheckStartStr(lineObject, printFlag, checkObject);
        if (flag && (flag = LineCheck.CheckSlotFiller(lineObject, printFlag, checkObject, tokenObject = new TokenObject(), checkLength))) {
            updateLex.Update(lexObj, tokenObject.GetToken());
        }
        return flag;
    }

    private static boolean CheckOneMany(LineObject lineObject, boolean printFlag, CheckSt st, LexRecord lexObj, CheckObject checkObject, UpdateLex updateLex, boolean checkLength) {
        boolean flag = false;
        if (st.GetCurState() != st.GetLastState()) {
            st.UpdateLastState();
            flag = CheckCode.CheckOne(lineObject, printFlag, st, lexObj, checkObject, updateLex, checkLength, false);
        } else {
            st.UpdateLastState();
            flag = CheckCode.CheckZeroMany(lineObject, printFlag, st, lexObj, checkObject, updateLex, checkLength);
        }
        return flag;
    }

    private static boolean CheckOneWholeLine(LineObject lineObject, boolean printFlag, CheckSt st, LexRecord lexObj, CheckObject checkObject, UpdateLex updateLex) {
        lineObject.SetGoToNext(true);
        boolean flag = LineCheck.CheckWholeLine(lineObject, printFlag, checkObject);
        if (flag) {
            st.UpdateLastState();
            st.UpdateCurState(checkObject.GetNextState());
            if (updateLex != null) {
                updateLex.Update(lexObj, lineObject.GetLine());
            }
        }
        return flag;
    }

    private static boolean CheckZeroOneWholeLine(LineObject lineObject, boolean printFlag, CheckSt st, LexRecord lexObj, CheckObject checkObject, UpdateLex updateLex) {
        boolean flag = checkObject.IsNextStartStr(lineObject.GetLine());
        if (flag) {
            st.UpdateCurState(checkObject.GetNextState());
            lineObject.SetGoToNext(false);
            return flag;
        }
        if (st.GetCurState() != st.GetLastState()) {
            st.UpdateLastState();
            flag = CheckCode.CheckOneWholeLine(lineObject, printFlag, st, lexObj, checkObject, updateLex);
        } else {
            String line = lineObject.GetLine();
            st.UpdateLastState();
            ErrMsg.PrintErrMsg(printFlag, 82, lineObject, line, 0, line.length(), checkObject.IsTab());
        }
        return flag;
    }
}

