/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lexCheck.Gram;

import gov.nih.nlm.nls.lexCheck.Cat.CheckCatEntry;
import gov.nih.nlm.nls.lexCheck.Cat.CheckFormatCat;
import gov.nih.nlm.nls.lexCheck.CkLib.CheckCode;
import gov.nih.nlm.nls.lexCheck.CkLib.CheckObject;
import gov.nih.nlm.nls.lexCheck.Gram.CheckFormatAbbreviation;
import gov.nih.nlm.nls.lexCheck.Gram.CheckFormatAcronym;
import gov.nih.nlm.nls.lexCheck.Gram.CheckFormatEui;
import gov.nih.nlm.nls.lexCheck.Gram.UpdateAbbreviation;
import gov.nih.nlm.nls.lexCheck.Gram.UpdateAcronym;
import gov.nih.nlm.nls.lexCheck.Gram.UpdateAnnotation;
import gov.nih.nlm.nls.lexCheck.Gram.UpdateBase;
import gov.nih.nlm.nls.lexCheck.Gram.UpdateCat;
import gov.nih.nlm.nls.lexCheck.Gram.UpdateEnd;
import gov.nih.nlm.nls.lexCheck.Gram.UpdateEntry;
import gov.nih.nlm.nls.lexCheck.Gram.UpdateSignature;
import gov.nih.nlm.nls.lexCheck.Gram.UpdateSpellingVar;
import gov.nih.nlm.nls.lexCheck.Lib.CheckSt;
import gov.nih.nlm.nls.lexCheck.Lib.LexRecord;
import gov.nih.nlm.nls.lexCheck.Lib.LineObject;
import java.util.HashSet;

public class CheckGrammer {
    private static LexRecord lexRecord_ = new LexRecord();
    private static CheckObject checkBase_ = null;
    private static CheckObject checkSpellingVar_ = null;
    private static HashSet<String> spellingVarNextStartStrs_ = new HashSet(1);
    private static CheckObject checkEntry_ = null;
    private static CheckObject checkCat_ = null;
    private static CheckObject checkAcronym_ = null;
    private static HashSet<String> acronymNextStartStrs_ = new HashSet(4);
    private static CheckObject checkAbbreviation_ = null;
    private static HashSet<String> abbreviationNextStartStrs_ = new HashSet(3);
    private static CheckObject checkAnnotation_ = null;
    private static HashSet<String> annotationNextStartStrs_ = new HashSet(2);
    private static CheckObject checkSignature_ = null;
    private static HashSet<String> signatureNextStartStrs_ = new HashSet(1);
    private static CheckObject checkEnd_ = null;

    public static boolean Check(LineObject lineObject, boolean printFlag, CheckSt st, CheckSt catSt, boolean debugFlag) {
        boolean flag = true;
        switch (st.GetCurState()) {
            case 10: {
                lexRecord_ = new LexRecord();
                flag = CheckCode.Check(lineObject, printFlag, st, lexRecord_, checkBase_, new UpdateBase(), 1, true);
                CheckGrammer.PrintStep(10, debugFlag, lineObject.GetLine());
                break;
            }
            case 20: {
                flag = CheckCode.Check(lineObject, printFlag, st, lexRecord_, checkSpellingVar_, new UpdateSpellingVar(), 3, true);
                CheckGrammer.PrintStep(20, debugFlag, lineObject.GetLine());
                break;
            }
            case 21: {
                flag = CheckCode.Check(lineObject, printFlag, st, lexRecord_, checkEntry_, new UpdateEntry(), 1, true);
                CheckGrammer.PrintStep(21, debugFlag, lineObject.GetLine());
                break;
            }
            case 30: {
                flag = CheckCode.Check(lineObject, printFlag, st, lexRecord_, checkCat_, new UpdateCat(), 1, true);
                CheckGrammer.PrintStep(30, debugFlag, lineObject.GetLine());
                break;
            }
            case 40: {
                flag = CheckCatEntry.Check(lineObject, printFlag, st, catSt, lexRecord_, 91, debugFlag);
                CheckGrammer.PrintStep(40, debugFlag, lineObject.GetLine());
                break;
            }
            case 91: {
                flag = CheckCode.Check(lineObject, printFlag, st, lexRecord_, checkAcronym_, new UpdateAcronym(), 3, true);
                CheckGrammer.PrintStep(91, debugFlag, lineObject.GetLine());
                break;
            }
            case 92: {
                flag = CheckCode.Check(lineObject, printFlag, st, lexRecord_, checkAbbreviation_, new UpdateAbbreviation(), 3, true);
                CheckGrammer.PrintStep(92, debugFlag, lineObject.GetLine());
                break;
            }
            case 95: {
                flag = CheckCode.Check(lineObject, printFlag, st, lexRecord_, checkAnnotation_, new UpdateAnnotation(), 3, true);
                CheckGrammer.PrintStep(95, debugFlag, lineObject.GetLine());
                break;
            }
            case 96: {
                flag = CheckCode.Check(lineObject, printFlag, st, lexRecord_, checkSignature_, new UpdateSignature(), 2, true);
                CheckGrammer.PrintStep(96, debugFlag, lineObject.GetLine());
                break;
            }
            case 99: {
                flag = CheckCode.Check(lineObject, printFlag, st, lexRecord_, checkEnd_, new UpdateEnd(), 5, false);
                CheckGrammer.PrintStep(99, debugFlag, lineObject.GetLine());
                break;
            }
        }
        return flag;
    }

    public static LexRecord GetLexRecord() {
        return lexRecord_;
    }

    private static void PrintStep(int state, boolean debugFlag, String line) {
        if (debugFlag) {
            switch (state) {
                case 10: {
                    System.out.println("-- Checked Base: '" + line + "'");
                    break;
                }
                case 20: {
                    System.out.println("-- Checked SPELLING_VAR: '" + line + "'");
                    break;
                }
                case 21: {
                    System.out.println("-- Checked Entry: '" + line + "'");
                    break;
                }
                case 30: {
                    System.out.println("-- Checked Cat: '" + line + "'");
                    break;
                }
                case 40: {
                    System.out.println("-- Checked Cat Entry: '" + line + "'");
                    break;
                }
                case 91: {
                    System.out.println("-- Checked Acronym: '" + line + "'");
                    break;
                }
                case 92: {
                    System.out.println("-- Checked Abbreviation: '" + line + "'");
                    break;
                }
                case 95: {
                    System.out.println("-- Checked Annotation: '" + line + "'");
                    break;
                }
                case 96: {
                    System.out.println("-- Checked Signature: '" + line + "'");
                    break;
                }
                case 99: {
                    System.out.println("-- Checked End: '" + line + "'");
                    break;
                }
            }
        }
    }

    static {
        checkBase_ = new CheckObject("{base=", 3, -1, 20, null, null);
        spellingVarNextStartStrs_.add("entry");
        checkSpellingVar_ = new CheckObject("spelling_variant=", 4, -1, 21, spellingVarNextStartStrs_, null);
        checkEntry_ = new CheckObject("entry=", 5, 6, 30, null, new CheckFormatEui());
        checkCat_ = new CheckObject("\tcat=", 8, 9, 40, null, new CheckFormatCat());
        acronymNextStartStrs_.add("\tabbreviation_of=");
        acronymNextStartStrs_.add("annotation=");
        acronymNextStartStrs_.add("signature=");
        acronymNextStartStrs_.add("}");
        checkAcronym_ = new CheckObject("\tacronym_of=", 18, 19, 92, acronymNextStartStrs_, new CheckFormatAcronym());
        abbreviationNextStartStrs_.add("annotation=");
        abbreviationNextStartStrs_.add("signature=");
        abbreviationNextStartStrs_.add("}");
        checkAbbreviation_ = new CheckObject("\tabbreviation_of=", 16, 17, 95, abbreviationNextStartStrs_, new CheckFormatAbbreviation());
        annotationNextStartStrs_.add("signature=");
        annotationNextStartStrs_.add("}");
        checkAnnotation_ = new CheckObject("annotation=", 12, -1, 96, annotationNextStartStrs_, null);
        signatureNextStartStrs_.add("}");
        checkSignature_ = new CheckObject("signature=", 13, -1, 99, signatureNextStartStrs_, null);
        checkEnd_ = new CheckObject("}", 15, -1, 10, null, null);
    }
}

