/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Db;

import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Db.DerivationRecord;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;

public class DbDerivation {
    public static Vector<DerivationRecord> GetDerivations(String inStr, Connection conn) throws SQLException {
        Vector<DerivationRecord> derivations = new Vector<DerivationRecord>();
        String query = "SELECT term1, cat1, term2, cat2 FROM Derivation WHERE termLc1= ?";
        PreparedStatement ps = conn.prepareStatement(query);
        ps.setString(1, inStr.toLowerCase());
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            DerivationRecord derivationRecord = new DerivationRecord(rs.getString(1), rs.getInt(2), rs.getString(3), rs.getInt(4));
            derivations.addElement(derivationRecord);
        }
        rs.close();
        ps.close();
        String query2 = "SELECT term2, cat2, term1, cat1 FROM Derivation WHERE termLc2= ?";
        PreparedStatement ps2 = conn.prepareStatement(query2);
        ps2.setString(1, inStr.toLowerCase());
        ResultSet rs2 = ps2.executeQuery();
        while (rs2.next()) {
            DerivationRecord derivationRecord = new DerivationRecord(rs2.getString(1), rs2.getInt(2), rs2.getString(3), rs2.getInt(4));
            derivations.addElement(derivationRecord);
        }
        rs.close();
        ps2.close();
        return derivations;
    }

    public static void main(String[] args) {
        String testStr = "multiple";
        if (args.length == 1) {
            testStr = args[0];
        }
        Configuration conf = new Configuration("data.config.lvg", true);
        try {
            Connection conn = DbBase.OpenConnection(conf);
            if (conn != null) {
                Vector<DerivationRecord> derivationList = DbDerivation.GetDerivations(testStr, conn);
                System.out.println("----- Total Derivations found: " + derivationList.size());
                for (int i = 0; i < derivationList.size(); ++i) {
                    if (i == 0) {
                        System.out.println("=== Found Derivations ===");
                    }
                    DerivationRecord record = derivationList.elementAt(i);
                    System.out.println(record.GetSource() + "|" + record.GetSourceCat() + "|" + record.GetTarget() + "|" + record.GetTargetCat());
                }
                DbBase.CloseConnection(conn, conf);
            }
        }
        catch (SQLException sqle) {
            System.err.println(sqle.getMessage());
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }
}

