/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.GlobalBehavior;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Util.UnicodeUtil;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class ToGetUnicodeSynonyms
extends Transformation
implements Cloneable {
    private static final String INFO = "Get Unicode Synonmy";
    private static final String NO_OPERATION = "NO";
    private static final String MAPPING = "MP";

    public static Vector<LexItem> Mutate(LexItem in, Hashtable<Character, Character> synonymMap, boolean detailsFlag, boolean mutateFlag) {
        Vector<LexItem> out = ToGetUnicodeSynonyms.GetUnicodeSynonyms(in, synonymMap, INFO, detailsFlag, mutateFlag);
        return out;
    }

    public static Hashtable<Character, Character> GetUnicodeSynonymMapFromFile(Configuration config) {
        String fName = config.GetConfiguration("LVG_DIR") + config.GetConfiguration("LVG_UNICODE_SYNONYM_FILE");
        String line = null;
        Hashtable<Character, Character> unicodeSynonymMap = new Hashtable<Character, Character>();
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fName), "UTF-8"));
            while ((line = in.readLine()) != null) {
                if (line.length() <= 0 || line.charAt(0) == '#') continue;
                StringTokenizer buf = new StringTokenizer(line, "|");
                char inChar = (char)UnicodeUtil.UnicodeHexToNum(buf.nextToken());
                char mapChar = (char)UnicodeUtil.UnicodeHexToNum(buf.nextToken());
                Character srcChar = new Character(inChar);
                Character tarChar = new Character(mapChar);
                unicodeSynonymMap.put(srcChar, tarChar);
            }
            in.close();
        }
        catch (Exception e) {
            System.err.println("** Error: problem of opening/reading symbol synonym file: '" + fName + "'.");
            System.err.println("Exception: " + e.toString());
        }
        return unicodeSynonymMap;
    }

    public static char GetUnicodeSynonym(char inChar, Hashtable<Character, Character> unicodeSynonymMap) {
        char outChar = inChar;
        if (unicodeSynonymMap.containsKey(Character.valueOf(inChar))) {
            outChar = unicodeSynonymMap.get(Character.valueOf(inChar)).charValue();
        }
        return outChar;
    }

    public static String GetUnicodeSynonym(String inStr, Hashtable<Character, Character> unicodeSynonymMap) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < inStr.length(); ++i) {
            char curChar = inStr.charAt(i);
            Character key = new Character(curChar);
            if (unicodeSynonymMap.containsKey(key)) {
                buffer.append(unicodeSynonymMap.get(key).charValue());
                continue;
            }
            buffer.append(curChar);
        }
        return buffer.toString();
    }

    public static void main(String[] args) {
        String testStr = ToGetUnicodeSynonyms.GetTestStr(args, "\u00a9 and \u00b5");
        Configuration conf = new Configuration("data.config.lvg", true);
        Hashtable<Character, Character> unicodeSynonymMap = ToGetUnicodeSynonyms.GetUnicodeSynonymMapFromFile(conf);
        LexItem in = new LexItem(testStr);
        Vector<LexItem> outs = ToGetUnicodeSynonyms.Mutate(in, unicodeSynonymMap, true, true);
        ToGetUnicodeSynonyms.PrintResults(in, outs);
    }

    private static Vector<LexItem> GetUnicodeSynonyms(LexItem in, Hashtable<Character, Character> unicodeSynonymMap, String infoStr, boolean detailsFlag, boolean mutateFlag) {
        String details = null;
        String mutate = null;
        if (detailsFlag) {
            details = infoStr;
        }
        if (mutateFlag) {
            mutate = new String();
        }
        String inStr = in.GetSourceTerm();
        String fs = GlobalBehavior.GetFieldSeparator();
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < inStr.length(); ++i) {
            char curChar = inStr.charAt(i);
            String opStr = NO_OPERATION + fs;
            Character key = new Character(curChar);
            if (unicodeSynonymMap.containsKey(key)) {
                buffer.append(unicodeSynonymMap.get(key).charValue());
                opStr = MAPPING + fs;
            } else {
                buffer.append(curChar);
            }
            if (!mutateFlag) continue;
            mutate = mutate + opStr;
        }
        String term = buffer.toString();
        Vector<LexItem> out = new Vector<LexItem>();
        LexItem temp = ToGetUnicodeSynonyms.UpdateLexItem(in, term, 54, -1L, -1L, details, mutate);
        out.addElement(temp);
        return out;
    }
}

