/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Db.DbInflection;
import gov.nih.nlm.nls.lvg.Db.InflectionRecord;
import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.Category;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.GlobalBehavior;
import gov.nih.nlm.nls.lvg.Lib.Inflection;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Lib.LexItemComparator;
import gov.nih.nlm.nls.lvg.Lib.OutputFilter;
import gov.nih.nlm.nls.lvg.Trie.RamTrie;
import gov.nih.nlm.nls.lvg.Trie.RuleResult;
import java.sql.Connection;
import java.util.Collections;
import java.util.Vector;

public class ToInflection
extends Transformation
implements Cloneable {
    private static final String INFO = "Inflection";

    public static Vector<LexItem> Mutate(LexItem in, Connection conn, RamTrie trie, int restrictFlag, boolean detailsFlag, boolean mutateFlag) {
        Vector<LexItem> out = ToInflection.InflectWords(in, conn, trie, restrictFlag, INFO, detailsFlag, mutateFlag, 1);
        return out;
    }

    public static void main(String[] args) {
        Configuration conf = new Configuration("data.config.lvg", true);
        String testStr = ToInflection.GetTestStr(args, "sleep");
        int minTermLen = Integer.parseInt(conf.GetConfiguration("MIN_TERM_LENGTH"));
        String lvgDir = conf.GetConfiguration("LVG_DIR");
        LexItem in = new LexItem(testStr, 2047L, 0xFFFFFFL);
        Vector<LexItem> outs = new Vector<LexItem>();
        try {
            Connection conn = DbBase.OpenConnection(conf);
            if (conn == null) {
                System.err.println("** Error: Db connection problem!");
            }
            boolean isInflection = true;
            RamTrie trie = new RamTrie(isInflection, minTermLen, lvgDir, 0);
            if (conn != null) {
                outs = ToInflection.Mutate(in, conn, trie, 2, true, true);
            }
            DbBase.CloseConnection(conn, conf);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        ToInflection.PrintResults(in, outs);
    }

    static Vector<LexItem> InflectWords(LexItem in, Connection conn, RamTrie trie, int restrictFlag, String infoStr, boolean detailsFlag, boolean mutateFlag, int flowName) {
        String inStr = in.GetSourceTerm();
        long inCat = in.GetSourceCategory().GetValue();
        long inInfl = in.GetSourceInflection().GetValue();
        Vector<LexItem> out = new Vector<LexItem>();
        try {
            Vector<InflectionRecord> factList = DbInflection.GetInflections(inStr, inCat, inInfl, conn);
            Vector<LexItem> facts = new Vector<LexItem>();
            for (int i = 0; i < factList.size(); ++i) {
                InflectionRecord record = factList.elementAt(i);
                String term = record.GetInflectedTerm();
                String details = null;
                String mutate = null;
                if (detailsFlag) {
                    details = infoStr + " (FACT|" + record.GetUninflectedTerm() + "|" + Category.ToName(record.GetCategory()) + "|base)";
                }
                if (mutateFlag) {
                    String fs = GlobalBehavior.GetFieldSeparator();
                    mutate = "FACT" + fs + record.GetUninflectedTerm() + fs + Category.ToName(record.GetCategory()) + fs + "base" + fs + term + fs + Category.ToName(record.GetCategory()) + fs + Inflection.ToName(record.GetInflection()) + fs;
                }
                LexItem temp = ToInflection.UpdateLexItem(in, term, flowName, record.GetCategory(), record.GetInflection(), details, mutate);
                facts.addElement(temp);
            }
            Vector<LexItem> rules = new Vector<LexItem>();
            if (restrictFlag == 3 || restrictFlag == 2 && facts.size() == 0) {
                Vector<RuleResult> ruleList = trie.GetInflectedTermsByRules(inStr, inCat, inInfl, true);
                for (int i = 0; i < ruleList.size(); ++i) {
                    RuleResult record = ruleList.elementAt(i);
                    String term = record.GetOutTerm();
                    if (DbInflection.IsExistInflectedTerm(term, conn)) continue;
                    String details = null;
                    String mutate = null;
                    if (detailsFlag) {
                        details = infoStr + " (RULE|" + record.GetInTerm() + "|" + record.GetRuleString() + ")";
                    }
                    if (mutateFlag) {
                        String fs = GlobalBehavior.GetFieldSeparator();
                        mutate = "RULE" + fs + record.GetInTerm() + fs + record.GetRuleString() + fs;
                    }
                    LexItem temp = ToInflection.UpdateLexItem(in, term, flowName, Category.ToValue(record.GetOutCategory()), Inflection.ToValue(record.GetOutInflection()), details, mutate);
                    rules.addElement(temp);
                }
            }
            out = OutputFilter.RestrictOption(facts, rules, restrictFlag);
        }
        catch (Exception e) {
            System.err.println("** Error: Sql Exception in ToInflection Flow.");
        }
        LexItemComparator lc = new LexItemComparator();
        lc.SetRule(10);
        Collections.sort(out, lc);
        return out;
    }
}

