/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Lib;

import gov.nih.nlm.nls.lvg.Api.FieldsApi;
import gov.nih.nlm.nls.lvg.Lib.Category;
import gov.nih.nlm.nls.lvg.Lib.CombineRecords;
import gov.nih.nlm.nls.lvg.Lib.GlobalBehavior;
import gov.nih.nlm.nls.lvg.Lib.Inflection;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import gov.nih.nlm.nls.lvg.Lib.LexItemComparator;
import gov.nih.nlm.nls.lvg.Lib.LvgOutputOption;
import gov.nih.nlm.nls.lvg.Util.Bit;
import java.util.Collections;
import java.util.Vector;

public class OutputFilter {
    public static final int NOT_DERIVATION = 0;
    public static final int LVG_ONLY = 1;
    public static final int LVG_OR_ALL = 2;
    public static final int ALL = 3;
    public static final int PRESERVED_CASE = 1;
    public static final int LOWERCASE = 2;
    public static final int UPPERCASE = 3;
    protected static final String HEAD = "<";
    protected static final String TAIL = ">";

    public static String ExecuteOutputFilter(Vector<LexItem> results, boolean mutateFlag, boolean detailsFlag, String separator, String originalTerm, LvgOutputOption lvgOutputOption) {
        return OutputFilter.ExecuteOutputFilter(results, mutateFlag, detailsFlag, separator, originalTerm, originalTerm, lvgOutputOption);
    }

    public static String ExecuteOutputFilter(Vector<LexItem> results, boolean mutateFlag, boolean detailsFlag, String separator, String originalTerm, String inTerm, LvgOutputOption lvgOutputOption) {
        String outStr = new String();
        StringBuffer buffer = new StringBuffer();
        try {
            LexItem temp;
            int i;
            Vector<LexItem> combinedResults = CombineRecords.Combine(results, lvgOutputOption.GetCombineRule());
            if (lvgOutputOption.GetSortFlag() != 0) {
                LexItemComparator lc = new LexItemComparator();
                lc.SetRule(lvgOutputOption.GetSortFlag());
                Collections.sort(combinedResults, lc);
            }
            int recNum = 0;
            long excCat = Bit.Minus(2047L, lvgOutputOption.GetExcludeCategory());
            long excInfl = Bit.Minus(0xFFFFFFL, lvgOutputOption.GetExcludeInflection());
            Vector<LexItem> finalResults = new Vector<LexItem>();
            for (i = 0; i < combinedResults.size(); ++i) {
                temp = combinedResults.elementAt(i);
                if (!OutputFilter.IsRecContainCategoryInflection(temp, lvgOutputOption.GetOutCategory(), lvgOutputOption.GetOutInflection()) || !OutputFilter.IsCategoryInflectionContainRec(temp, excCat, excInfl)) continue;
                finalResults.add(temp);
            }
            if (finalResults.size() == 0 && lvgOutputOption.GetNoOutputFlag()) {
                String out = originalTerm;
                if (lvgOutputOption.GetFilterInputFlag()) {
                    out = inTerm;
                }
                String resultStr = out + separator + lvgOutputOption.GetNoOutputStr();
                String filteredStr = OutputFilter.FieldFilter(resultStr, lvgOutputOption.GetOutputFieldList());
                buffer.append(filteredStr);
                buffer.append(System.getProperty("line.separator").toString());
            }
            for (i = 0; i < finalResults.size(); ++i) {
                temp = (LexItem)finalResults.elementAt(i);
                String resultStr = LexItem.GetResultString(temp, originalTerm, mutateFlag, lvgOutputOption.GetCaseFlag(), lvgOutputOption.GetShowCategoryStrFlag(), lvgOutputOption.GetShowInflectionStrFlag(), lvgOutputOption.GetFilterInputFlag(), separator);
                String filteredStr = OutputFilter.FieldFilter(resultStr, lvgOutputOption.GetOutputFieldList());
                buffer.append(filteredStr);
                buffer.append(GlobalBehavior.LS_STR);
                ++recNum;
                if (detailsFlag) {
                    buffer.append(temp.GetDetailInformation());
                    buffer.append(GlobalBehavior.LS_STR);
                }
                if (lvgOutputOption.GetOutRecordNum() > 0 && recNum >= lvgOutputOption.GetOutRecordNum()) break;
            }
            if (lvgOutputOption.GetMarkEndFlag()) {
                String endMarkStr = lvgOutputOption.GetMarkEndStr();
                buffer.append(endMarkStr);
                buffer.append(GlobalBehavior.LS_STR);
            }
        }
        catch (Exception e) {
            System.err.println("** Error in ExecuteOutoutFilter( ): " + e.toString());
        }
        outStr = buffer.toString();
        return outStr;
    }

    public static Vector<LexItem> GetSimpleInflection(Vector<LexItem> ins) {
        Vector<LexItem> outs = new Vector<LexItem>();
        for (int i = 0; i < ins.size(); ++i) {
            LexItem in = ins.elementAt(i);
            LexItem out = OutputFilter.GetSimpleInflection(in);
            if (out == null) continue;
            outs.addElement(out);
        }
        return outs;
    }

    public static Vector<LexItem> GetEnhancedSimpleInflection(Vector<LexItem> ins) {
        Vector<LexItem> outs = new Vector<LexItem>();
        for (int i = 0; i < ins.size(); ++i) {
            LexItem in = ins.elementAt(i);
            LexItem out = OutputFilter.GetEnhancedSimpleInflection(in);
            if (out == null) continue;
            outs.addElement(out);
        }
        return outs;
    }

    public static LexItem GetSimpleInflection(LexItem in) {
        Inflection infl = in.GetTargetInflection();
        long inflValue = Bit.Minus(infl.GetValue(), 0xFFFE00L);
        LexItem out = null;
        if (inflValue > 0L) {
            out = new LexItem(in, true);
            out.SetTargetInflection(inflValue);
        }
        return out;
    }

    public static LexItem GetEnhancedSimpleInflection(LexItem in) {
        Inflection infl = in.GetTargetInflection();
        long inflValue = Bit.Minus(infl.GetValue(), 0xFFFE00L);
        LexItem out = null;
        long cat = in.GetTargetCategory().GetValue();
        if (inflValue > 0L || cat == Category.ToValue("aux") || cat == Category.ToValue("modal")) {
            out = new LexItem(in, true);
            out.SetTargetInflection(inflValue);
        }
        return out;
    }

    public static boolean IsRecContainCategory(LexItem in, long category) {
        boolean containFlag = Bit.Contain(in.GetTargetCategory().GetValue(), category);
        return containFlag;
    }

    public static boolean IsCategoryContainRec(LexItem in, long category) {
        if (category == 2047L) {
            return true;
        }
        boolean containFlag = Bit.Contain(category, in.GetTargetCategory().GetValue());
        return containFlag;
    }

    public static boolean IsRecContainCategoryInflection(LexItem in, long category, long inflection) {
        boolean catFlag = category == 2047L || Bit.Contain(in.GetTargetCategory().GetValue(), category);
        boolean inflFlag = inflection == 0xFFFFFFL || Bit.Contain(in.GetTargetInflection().GetValue(), inflection);
        boolean containFlag = catFlag && inflFlag;
        return containFlag;
    }

    public static boolean IsCategoryInflectionContainRec(LexItem in, long category, long inflection) {
        boolean catFlag = category == 2047L || Bit.Contain(category, in.GetTargetCategory().GetValue());
        boolean inflFlag = inflection == 0xFFFFFFL || Bit.Contain(inflection, in.GetTargetInflection().GetValue());
        boolean containFlag = catFlag && inflFlag;
        return containFlag;
    }

    public static Vector<LexItem> RestrictOption(Vector<LexItem> facts, Vector<LexItem> rules, int restrictFlag) {
        Vector<LexItem> out = new Vector<LexItem>();
        switch (restrictFlag) {
            case 1: {
                out.addAll(facts);
                break;
            }
            case 3: {
                out.addAll(facts);
                out.addAll(rules);
                break;
            }
            case 2: {
                out.addAll(facts);
                if (out.size() != 0) break;
                out.addAll(rules);
            }
        }
        return out;
    }

    private static String ModifyCase(String inStr, int caseFlag) {
        String out = inStr;
        switch (caseFlag) {
            case 2: {
                out = inStr.toLowerCase();
                break;
            }
            case 3: {
                out = inStr.toUpperCase();
            }
        }
        return out;
    }

    private static String FieldFilter(String inStr, Vector<Integer> fieldList) {
        String fs = GlobalBehavior.GetFieldSeparator();
        return FieldsApi.Mutate(inStr, fs, fieldList);
    }
}

