/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.morphology.english;

public class DeterminerAgrHelper {
    private static final String[] AN_EXCEPTIONS = new String[]{"one", "180", "110"};
    private static final String AN_AGREEMENT = "\\A(a|e|i|o|u).*";

    public static boolean requiresAn(String string) {
        boolean req = false;
        String lowercaseInput = string.toLowerCase();
        if (lowercaseInput.matches(AN_AGREEMENT) && !DeterminerAgrHelper.isAnException(lowercaseInput)) {
            req = true;
        } else {
            String numPref = DeterminerAgrHelper.getNumericPrefix(lowercaseInput);
            if (numPref != null && numPref.length() > 0 && numPref.matches("^(8|11|18).*$")) {
                Integer num = Integer.parseInt(numPref);
                req = DeterminerAgrHelper.checkNum(num);
            }
        }
        return req;
    }

    private static boolean isAnException(String string) {
        for (String ex : AN_EXCEPTIONS) {
            if (!string.matches("^" + ex + ".*")) continue;
            return true;
        }
        return false;
    }

    private static boolean checkNum(int num) {
        boolean needsAn = false;
        if (num == 11 || num == 18 || num == 8 || num >= 80 && num < 90) {
            needsAn = true;
        } else if (num > 1000) {
            num = Math.round(num / 1000);
            needsAn = DeterminerAgrHelper.checkNum(num);
        }
        return needsAn;
    }

    private static String getNumericPrefix(String string) {
        StringBuffer buffer;
        char first;
        StringBuffer numeric = new StringBuffer();
        if (string != null && (string = string.trim()).length() > 0 && Character.isDigit(first = (buffer = new StringBuffer(string)).charAt(0))) {
            numeric.append(first);
            for (int i = 1; i < buffer.length(); ++i) {
                Character next = Character.valueOf(buffer.charAt(i));
                if (Character.isDigit(next.charValue())) {
                    numeric.append(next);
                    continue;
                }
                if (!next.equals(Character.valueOf(','))) break;
            }
        }
        return numeric.length() == 0 ? null : numeric.toString();
    }

    static String checkEndsWithIndefiniteArticle(String text, String np) {
        String[] tokens = text.split(" ");
        String lastToken = tokens[tokens.length - 1];
        if (lastToken.equalsIgnoreCase("a") && DeterminerAgrHelper.requiresAn(np)) {
            tokens[tokens.length - 1] = "an";
            return DeterminerAgrHelper.stringArrayToString(tokens);
        }
        return text;
    }

    private static String stringArrayToString(String[] sArray) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < sArray.length; ++i) {
            buf.append(sArray[i]);
            if (i == sArray.length - 1) continue;
            buf.append(" ");
        }
        return buf.toString();
    }
}

