/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.commands;

import com.fabriziopolo.textcraft.commands.UserAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class ActionsAndHints {
    public final List<UserAction> actions = new ArrayList<UserAction>();
    public final List<String> hints = new ArrayList<String>();

    public ActionsAndHints() {
    }

    public ActionsAndHints(Collection<? extends UserAction> actions) {
        this.actions.addAll(actions);
    }

    public static ActionsAndHints hint(String hint) {
        ActionsAndHints resultsAndHints = new ActionsAndHints();
        resultsAndHints.addHint(hint);
        return resultsAndHints;
    }

    public static ActionsAndHints action(UserAction result) {
        ActionsAndHints resultsAndHints = new ActionsAndHints();
        resultsAndHints.addAction(result);
        return resultsAndHints;
    }

    public ActionsAndHints addHint(String hint) {
        if (!this.hints.contains(hint)) {
            this.hints.add(hint);
        }
        return this;
    }

    public ActionsAndHints addAllHints(Collection<String> moreHints) {
        moreHints.forEach(hint -> this.addHint((String)hint));
        return this;
    }

    public ActionsAndHints addAction(UserAction result) {
        this.actions.add(result);
        return this;
    }

    public ActionsAndHints addAllActions(Collection<? extends UserAction> moreResults) {
        this.actions.addAll(moreResults);
        return this;
    }

    public ActionsAndHints addAll(ActionsAndHints resultsAndHints) {
        if (resultsAndHints != null) {
            this.addAllActions(resultsAndHints.actions);
            this.addAllHints(resultsAndHints.hints);
        }
        return this;
    }

    public ActionsAndHints addAll(Collection<? extends ActionsAndHints> resultsAndHintss) {
        if (resultsAndHintss != null) {
            resultsAndHintss.forEach(this::addAll);
        }
        return this;
    }

    public ActionsAndHints deduped() {
        Map<String, List<UserAction>> groupedResults = this.actions.stream().collect(Collectors.groupingBy(result -> result.getDescription()));
        ActionsAndHints deduped = new ActionsAndHints();
        deduped.addAllHints(this.hints);
        groupedResults.forEach((resultDescription, resultsWithDescription) -> deduped.addAction((UserAction)resultsWithDescription.get(0)));
        return deduped;
    }
}

