/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.commands;

import com.fabriziopolo.textapp.TextAppController;
import com.fabriziopolo.textcraft.commands.AbstractUserAction;
import com.fabriziopolo.textcraft.commands.AbstractVerbDirectionCommand;
import com.fabriziopolo.textcraft.commands.ActionsAndHints;
import com.fabriziopolo.textcraft.commands.Command;
import com.fabriziopolo.textcraft.events.position.PlayerLooksInDirectionEvent;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;

public final class LookDirectionCommand
extends AbstractVerbDirectionCommand {
    public LookDirectionCommand() {
        super(new String[]{"look", "l"});
    }

    @Override
    public ActionsAndHints createMatchResult(String verb, Noun direction, Command.Context context) {
        ActionsAndHints results = new ActionsAndHints();
        results.addAction(new Result(direction, context));
        return results;
    }

    @Override
    public String getHelpString() {
        return "To look in a direction, type 'look' followed by the direction you want to look.  For instance, 'look west'.  If you want to look around your immediate surroundings type 'look' all by itself.";
    }

    @Override
    public String getNameString() {
        return null;
    }

    @Override
    public String getPurposeString() {
        return null;
    }

    @Override
    public boolean isVisibleInHelp() {
        return false;
    }

    @Override
    public String getHintForBadDirection() {
        return this.getHelpString();
    }

    public static final class Result
    extends AbstractUserAction {
        private final Noun direction;

        public Result(Noun direction, Command.Context context) {
            super(context);
            this.direction = direction;
        }

        @Override
        public String getDescription() {
            return "to look " + this.direction.getContextFreeDescription();
        }

        @Override
        public void execute(TextAppController controller) {
            PlayerLooksInDirectionEvent.post(this.direction, this.context);
        }

        @Override
        public boolean isValid(Frame frame) {
            return false;
        }
    }
}

