/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.commands;

import com.fabriziopolo.textapp.TextAppController;
import com.fabriziopolo.textcraft.commands.ActionsAndHints;
import com.fabriziopolo.textcraft.commands.Command;
import com.fabriziopolo.textcraft.commands.UserAction;
import com.fabriziopolo.textcraft.events.notification.PlayerNotificationEvent;
import com.fabriziopolo.textcraft.states.singleplayer.PauseGameState;

public class PauseCommand
implements Command {
    @Override
    public ActionsAndHints parse(String[] words, Command.Context context) {
        if (words.length == 0) {
            return null;
        }
        String word = words[0].toLowerCase();
        if (!word.equals("pause") && !word.equals("p")) {
            return null;
        }
        if (words.length > 1) {
            return ActionsAndHints.hint(this.getHelpString());
        }
        return ActionsAndHints.action(new PauseGameAction(context));
    }

    @Override
    public String getHelpString() {
        return "Type 'pause' or 'p' to pause the game.  It will automatically resume the next time you enter a command.";
    }

    @Override
    public String getNameString() {
        return "pause";
    }

    @Override
    public String getPurposeString() {
        return "Pause the game. (p)";
    }

    @Override
    public boolean isVisibleInHelp() {
        return true;
    }

    private static final class PauseGameAction
    implements UserAction {
        private final Command.Context context;

        private PauseGameAction(Command.Context context) {
            this.context = context;
        }

        @Override
        public String getDescription() {
            return "to pause the game";
        }

        @Override
        public void execute(TextAppController controller) {
            PlayerNotificationEvent.postAlwaysPerceivable("The game is paused.  Type any commmand to continue.", this.context);
            PauseGameState.requestPauseGame(this.context.simulation);
            controller.getUi().clearInput();
        }
    }
}

