/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.nlg;

import com.fabriziopolo.textcraft.nlg.Sentences;
import java.util.ArrayList;
import java.util.List;

public class SimpleDocument
implements Sentences {
    private static final LineSeparator LINE_SEPERATOR = new LineSeparator();
    private final List<Object> components;

    public SimpleDocument(Builder builder) {
        this.components = builder.components;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.components.forEach(text -> builder.append(text));
        return builder.toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static final class LineSeparator {
        private LineSeparator() {
        }

        public String toString() {
            return "\n";
        }
    }

    public static final class Builder {
        private final List<Object> components = new ArrayList<Object>();

        public Builder appendSentences(Sentences text) {
            if (text != null) {
                this.components.add(text);
            }
            return this;
        }

        public Builder appendSentencesOnNewLine(Sentences text) {
            if (text != null) {
                if (!this.components.isEmpty()) {
                    this.components.add(LINE_SEPERATOR);
                }
                this.components.add(text);
            }
            return this;
        }

        public SimpleDocument build() {
            return new SimpleDocument(this);
        }
    }
}

