/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.states.characterbio;

import com.fabriziopolo.textcraft.nlg.IndependentClause;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.states.characterbio.energy.EnergyState;
import com.fabriziopolo.textcraft.states.characterbio.health.HealthState;
import com.fabriziopolo.textcraft.states.characterbio.hunger.HungerState;
import com.fabriziopolo.textcraft.states.characterbio.hydration.HydrationState;
import com.fabriziopolo.textcraft.text.Text;
import java.io.Serializable;

public class CharacterBioEffect
implements Serializable {
    private final double deltaEnergy;
    private final double deltaHunger;
    private final double deltaHydration;
    private final double deltaHealth;

    private CharacterBioEffect(Builder builder) {
        this.deltaEnergy = builder.deltaEnergy;
        this.deltaHunger = builder.deltaHunger;
        this.deltaHydration = builder.deltaHydration;
        this.deltaHealth = builder.deltaHealth;
    }

    public void apply(Simulation simulation, Noun target, IndependentClause cause) {
        this.apply(simulation, target, cause, true);
    }

    public void apply(Simulation simulation, Noun target, IndependentClause cause, boolean notifyOfChange) {
        Frame frame = simulation.getCurrentFrame();
        if (this.deltaEnergy != 0.0) {
            EnergyState.get(frame).requestChange(simulation, target, this.deltaEnergy, cause, notifyOfChange);
        }
        if (this.deltaHunger != 0.0) {
            HungerState.get(frame).requestChange(simulation, target, this.deltaHunger, cause, notifyOfChange);
        }
        if (this.deltaHydration != 0.0) {
            HydrationState.get(frame).requestChange(simulation, target, this.deltaHydration, cause, notifyOfChange);
        }
        if (this.deltaHealth != 0.0) {
            HealthState.get(frame).requestChange(simulation, target, this.deltaHealth, cause, notifyOfChange);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder dayTimeScaleBuilder(Simulation simulation) {
        return CharacterBioEffect.builder().scaleBy(simulation.getUpdateParameters().getDeltaForRatePerDay(1.0));
    }

    public String toString() {
        return "BioEffect(E=" + Text.displayValue(this.deltaEnergy) + ", FD=" + Text.displayValue(this.deltaHunger) + ", H2O=" + Text.displayValue(this.deltaHydration) + ", H=" + Text.displayValue(this.deltaHealth) + ")";
    }

    public static final class Builder {
        private double deltaEnergy;
        private double deltaHunger;
        private double deltaHydration;
        private double deltaHealth;
        private double scale = 1.0;

        public Builder addEnergy(double deltaEnergy) {
            this.deltaEnergy += deltaEnergy;
            return this;
        }

        public Builder addFood(double deltaHunger) {
            this.deltaHunger += deltaHunger;
            return this;
        }

        public Builder addHydration(double deltaHydration) {
            this.deltaHydration += deltaHydration;
            return this;
        }

        public Builder addHealth(double deltaHealth) {
            this.deltaHealth += deltaHealth;
            return this;
        }

        public Builder scaleBy(double scale) {
            this.scale *= scale;
            return this;
        }

        public CharacterBioEffect build() {
            this.deltaEnergy *= this.scale;
            this.deltaHydration *= this.scale;
            this.deltaHunger *= this.scale;
            this.deltaHealth *= this.scale;
            return new CharacterBioEffect(this);
        }
    }
}

