/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.states.characterbio.energy;

import com.fabriziopolo.textcraft.nlg.IndependentClause;
import com.fabriziopolo.textcraft.simulation.Event;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.simulation.State;
import com.fabriziopolo.textcraft.states.NotifyingNumberWithCauseState;
import com.fabriziopolo.textcraft.states.characterbio.energy.EnergyStateBuilder;
import com.fabriziopolo.textcraft.states.characterbio.health.HealthState;
import com.fabriziopolo.textcraft.states.characterbio.hunger.HungerState;
import com.fabriziopolo.textcraft.states.characterbio.hydration.HydrationState;
import com.fabriziopolo.textcraft.states.notification.Notification;
import com.fabriziopolo.textcraft.states.notification.NotificationKey;
import com.fabriziopolo.textcraft.states.notification.NotificationState;

public class EnergyState
extends NotifyingNumberWithCauseState {
    private static final NotificationKey NOTIFICATION_KEY = new NotificationKey(EnergyState.class);
    private static final int NOTIFICATION_REPEAT_RATE = 50;
    private static final int NOTIFICATION_TIMEOUT = 1;
    private static final double MAX_ENERGY_MARGIN = 0.1;
    private static final double MIN_MAX_VALUE = 0.1;
    private static final double UNCONSCIOUS_THRESHOLD = 0.0;
    private static final double DELERIOUS_THRESHOLD = 0.1;
    private static final double EXHAUSTED_THRESHOLD = 0.3;
    private static final double TIRED_THRESHOLD = 0.5;
    private static final double ABLE_THRESHOLD = 0.7;

    public static EnergyState get(Frame frame) {
        return (EnergyState)frame.states.get(EnergyState.class);
    }

    @Override
    public NotifyingNumberWithCauseState.NumberWithCauses get(Noun noun) {
        return (NotifyingNumberWithCauseState.NumberWithCauses)super.get(noun);
    }

    private Double getInstantaneousMaxEnergy(Noun noun, Frame frame) {
        Double hunger = HungerState.get(frame).getValue(noun);
        Double thirst = HydrationState.get(frame).getValue(noun);
        NotifyingNumberWithCauseState.NumberWithCauses temp = HealthState.get(frame).get(noun);
        Double health = temp == null ? 1.0 : temp.value;
        double max = this.getMaxValue();
        if (hunger != null) {
            max = Math.min(max, hunger);
        }
        if (thirst != null) {
            max = Math.min(max, thirst);
        }
        if (health != null) {
            max = Math.min(max, health);
        }
        max += 0.1;
        max = Math.min(1.0, Math.max(max, 0.1));
        return max;
    }

    public Double getMaxEnergy(Noun noun, Frame frame) {
        Double max = this.getInstantaneousMaxEnergy(noun, frame);
        NotifyingNumberWithCauseState.NumberWithCauses currentEnergy = this.get(noun);
        max = currentEnergy == null ? max : Math.max(max, currentEnergy.value);
        return max;
    }

    @Override
    protected Class getStateKey() {
        return EnergyState.class;
    }

    @Override
    public State updateState(Simulation simulation) {
        EnergyState newState = this.getUpdatedEnergyState(simulation);
        return newState;
    }

    @Override
    protected NotificationKey getNotificationKey() {
        return NOTIFICATION_KEY;
    }

    @Override
    protected int getNotificationRepeatRate() {
        return 50;
    }

    @Override
    protected int getNotificationTimeout() {
        return 1;
    }

    @Override
    protected String getIncreaseDescription() {
        return "are energized";
    }

    @Override
    protected String getDecreaseDescription() {
        return "become tired";
    }

    @Override
    protected Event.Style getNotificationStyle(double value, double change) {
        if (value < 0.1 && change < 0.0) {
            return Event.Style.WARNING;
        }
        return Event.Style.DEFAULT;
    }

    private EnergyState getUpdatedEnergyState(Simulation simulation) {
        EnergyStateBuilder newState = new EnergyStateBuilder();
        this.setUpdatedState(simulation, newState);
        newState.getValueMap().replaceAll((noun, energyWithCause) -> {
            double maxEnergy = this.getInstantaneousMaxEnergy((Noun)noun, simulation.getCurrentFrame());
            return energyWithCause.withNewValue(Math.max(0.0, Math.min(maxEnergy, energyWithCause.value)));
        });
        newState.getValueMap().forEach((noun, energyWithCause) -> this.maybePostLowNotification(simulation, (Noun)noun, energyWithCause.value));
        return newState.build();
    }

    private void maybePostLowNotification(Simulation simulation, Noun noun, double energy) {
        if (energy > 0.5) {
            return;
        }
        NotificationState.post(simulation, new Notification("You are " + EnergyState.getEnergyDescription(energy) + ".", noun, NOTIFICATION_KEY, EnergyState.getLowEnergyRepeatRateSeconds(energy), 1L, EnergyState.getNotificationStyle(energy)));
    }

    public static String getEnergyDescription(double energy) {
        if (energy <= 0.0) {
            return "unconscious";
        }
        if (energy <= 0.1) {
            return "deleriously exhausted";
        }
        if (energy <= 0.3) {
            return "exhausted";
        }
        if (energy <= 0.5) {
            return "tired";
        }
        if (energy <= 0.7) {
            return "able";
        }
        return "enthusiastic";
    }

    private static int getLowEnergyRepeatRateSeconds(double energy) {
        if (energy <= 0.0) {
            return 10000;
        }
        if (energy <= 0.1) {
            return 15;
        }
        if (energy <= 0.3) {
            return 40;
        }
        if (energy <= 0.5) {
            return 120;
        }
        if (energy <= 0.7) {
            return 10000;
        }
        return 10000;
    }

    private static Event.Style getNotificationStyle(double energy) {
        if (energy <= 0.1) {
            return Event.Style.WARNING;
        }
        return Event.Style.DEFAULT;
    }

    public static EnergyStateBuilder builder() {
        return new EnergyStateBuilder();
    }

    public static void requestChange(Noun noun, double delta, IndependentClause cause, Simulation simulation) {
        EnergyState.get(simulation.getCurrentFrame()).requestChange(simulation, noun, delta, cause);
    }

    public static void requestChangeWithoutCause(Noun noun, double delta, Simulation simulation) {
        EnergyState.requestChange(noun, delta, null, simulation);
    }
}

