/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.states.constants;

import com.fabriziopolo.textcraft.objects.SimpleNoun;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.simulation.State;
import java.util.ArrayList;
import java.util.List;

public final class Directions
implements State {
    public final Noun north = Directions.createNorth();
    public final Noun south = Directions.createsouth();
    public final Noun east = Directions.createEast();
    public final Noun west = Directions.createWest();
    public final Noun up = Directions.createUp();
    public final Noun down = Directions.createDown();

    public final List<Noun> getAll() {
        ArrayList<Noun> allDirections = new ArrayList<Noun>();
        allDirections.add(this.north);
        allDirections.add(this.south);
        allDirections.add(this.east);
        allDirections.add(this.west);
        return allDirections;
    }

    public static Directions get(Frame frame) {
        return (Directions)frame.states.get(Directions.class);
    }

    public Noun oppositeOf(Noun direction) {
        if (direction == this.north) {
            return this.south;
        }
        if (direction == this.south) {
            return this.north;
        }
        if (direction == this.east) {
            return this.west;
        }
        if (direction == this.west) {
            return this.east;
        }
        if (direction == this.up) {
            return this.down;
        }
        if (direction == this.down) {
            return this.up;
        }
        throw new IllegalArgumentException("Direction not recognized.");
    }

    private static Noun createNorth() {
        return SimpleNoun.autoAlwaysVisible("north is a direction.", "north", "norths", "n", "n");
    }

    private static Noun createsouth() {
        return SimpleNoun.autoAlwaysVisible("south is a direction.", "south", "souths", "s", "s");
    }

    private static Noun createEast() {
        return SimpleNoun.autoAlwaysVisible("east is a direction.", "east", "easts", "e", "e");
    }

    private static Noun createWest() {
        return SimpleNoun.autoAlwaysVisible("west is a direction.", "west", "wests", "w", "w");
    }

    private static Noun createUp() {
        return SimpleNoun.autoAlwaysVisible("up is a direction.", "up", "ups", "u", "u");
    }

    private static Noun createDown() {
        return SimpleNoun.autoAlwaysVisible("down is a direction.", "down", "downs", "d", "d");
    }

    @Override
    public State updateState(Simulation simulation) {
        return this;
    }

    @Override
    public String getDebugInfo(Noun noun, Frame frame) {
        return null;
    }
}

