/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.states.position;

import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.states.position.PathSegment;
import com.fabriziopolo.textcraft.states.position.PositionState;
import com.fabriziopolo.textcraft.states.position.SpacialRelationship;
import java.util.List;

public abstract class AbstractPathAlgorithm {
    private SpacialRelationship finalEntranceSpacialRelationship;

    public final SpacialRelationship getFinalEntranceSpacialRelationship() {
        return this.finalEntranceSpacialRelationship;
    }

    protected boolean before(Frame frame) {
        return true;
    }

    protected boolean onDepart(Noun start, PathSegment firstSegment, Frame frame) {
        return true;
    }

    protected boolean onNoun(Noun noun, PathSegment segment, Frame frame) {
        return true;
    }

    protected boolean onInternalNoun(Noun noun, PathSegment segment, Frame frame) {
        return true;
    }

    protected boolean onEntranceOrExit(Noun noun, PathSegment segment, Frame frame) {
        return true;
    }

    protected boolean onArrive(Noun end, PathSegment lastSegment, Frame frame) {
        return true;
    }

    protected final boolean traversePathBetween(Noun start, Noun end, Frame frame) {
        return this.traversePath(PositionState.get(frame).getPathBetween(start, end), frame);
    }

    protected final boolean traversePathFromExterior(Noun end, Frame frame) {
        return this.traversePath(PositionState.get(frame).getPathFromExterior(end), frame);
    }

    protected final boolean traversePath(List<PathSegment> path, Frame frame) {
        this.finalEntranceSpacialRelationship = path.isEmpty() ? null : path.get((int)(path.size() - 1)).entranceDirection;
        if (!this.before(frame)) {
            return false;
        }
        if (path.size() == 0) {
            return true;
        }
        Noun start = path.get((int)0).startNoun;
        Noun end = path.get((int)(path.size() - 1)).endNoun;
        if (!this.onDepart(start, path.get(0), frame)) {
            return false;
        }
        if (!this.handleNullableOnNoun(start, path.get(0), frame)) {
            return false;
        }
        for (int i = 0; i < path.size(); ++i) {
            PathSegment segment = path.get(i);
            if (i != 0 && !this.handleNullableOnInternalNoun(segment.startNoun, segment, frame)) {
                return false;
            }
            if (!this.handleNullableOnNoun(segment.exit, segment, frame)) {
                return false;
            }
            if (!this.handleNullableOnEntranceOrExit(segment.exit, segment, frame)) {
                return false;
            }
            if (!this.handleNullableOnInternalNoun(segment.exit, segment, frame)) {
                return false;
            }
            if (!this.handleNullableOnNoun(segment.entrance, segment, frame)) {
                return false;
            }
            if (!this.handleNullableOnEntranceOrExit(segment.entrance, segment, frame)) {
                return false;
            }
            if (!this.handleNullableOnInternalNoun(segment.entrance, segment, frame)) {
                return false;
            }
            if (this.handleNullableOnNoun(segment.endNoun, segment, frame)) continue;
            return false;
        }
        return this.onArrive(end, path.get(path.size() - 1), frame);
    }

    private final boolean handleNullableOnNoun(Noun noun, PathSegment segment, Frame frame) {
        if (noun == null) {
            return true;
        }
        return this.onNoun(noun, segment, frame);
    }

    private final boolean handleNullableOnEntranceOrExit(Noun noun, PathSegment segment, Frame frame) {
        if (noun == null) {
            return true;
        }
        return this.onEntranceOrExit(noun, segment, frame);
    }

    private final boolean handleNullableOnInternalNoun(Noun noun, PathSegment segment, Frame frame) {
        if (noun == null) {
            return true;
        }
        return this.onInternalNoun(noun, segment, frame);
    }
}

